/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.model.AnchorActor;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.RectangleRenderer;

public class DebugDrawer {
    private final Skin skin;
    private final World w;
    private final Viewport viewport;
    private final StringBuilder sbTmp = new StringBuilder();
    private final Vector3 unprojectTmp = new Vector3();
    private final GlyphLayout textLayout = new GlyphLayout();

    public DebugDrawer(World w, Skin skin, Viewport viewport) {
        this.w = w;
        this.skin = skin;
        this.viewport = viewport;
    }

    public void draw(SpriteBatch batch) {
        Color color;
        this.w.getSceneCamera().getInputUnProject(this.viewport, this.unprojectTmp);
        this.sbTmp.setLength(0);
        if (EngineLogger.lastError != null) {
            this.sbTmp.append((CharSequence)EngineLogger.errorBuffer);
            color = Color.RED;
        } else {
            this.sbTmp.append(" ");
            long millis = this.w.getTimeOfGame();
            long second = millis / 1000L % 60L;
            long minute = millis / 60000L % 60L;
            long hour = millis / 3600000L;
            String time = String.format("%02d:%02d:%02d", hour, minute, second);
            this.sbTmp.append(time);
            if (EngineLogger.getDebugLevel() == 1) {
                if (this.w.inCutMode()) {
                    this.sbTmp.append(" CUT_MODE ");
                } else if (this.w.hasDialogOptions()) {
                    this.sbTmp.append(" DIALOG_MODE ");
                } else if (this.w.isPaused()) {
                    this.sbTmp.append(" PAUSED ");
                }
                this.sbTmp.append(" ( ");
                this.sbTmp.append((int)this.unprojectTmp.x);
                this.sbTmp.append(", ");
                this.sbTmp.append((int)this.unprojectTmp.y);
                this.sbTmp.append(") FPS:");
                this.sbTmp.append(Gdx.graphics.getFramesPerSecond());
                if (this.w.getCurrentScene().getState() != null) {
                    this.sbTmp.append(" Scn State: ");
                    this.sbTmp.append(this.w.getCurrentScene().getState());
                }
                if (this.w.getCurrentScene().getPlayer() != null) {
                    this.sbTmp.append(" Depth Scl: ");
                    this.sbTmp.append(this.w.getCurrentScene().getFakeDepthScale(this.unprojectTmp.y));
                }
            }
            color = Color.WHITE;
        }
        String strDebug = this.sbTmp.toString();
        this.textLayout.setText(this.skin.getFont("debug"), (CharSequence)strDebug, color, (float)this.viewport.getScreenWidth(), 8, true);
        RectangleRenderer.draw((Batch)batch, 0.0f, (float)this.viewport.getScreenHeight() - this.textLayout.height - 10.0f, this.textLayout.width, this.textLayout.height + 10.0f, Color.BLACK);
        this.skin.getFont("debug").draw((Batch)batch, this.textLayout, 0.0f, (float)(this.viewport.getScreenHeight() - 5));
        if (EngineLogger.getDebugLevel() == 1) {
            for (BaseActor a : this.w.getCurrentScene().getActors().values()) {
                if (a instanceof AnchorActor) continue;
                Rectangle r = a.getBBox().getBoundingRectangle();
                this.sbTmp.setLength(0);
                this.sbTmp.append(a.getId());
                if (a instanceof InteractiveActor && ((InteractiveActor)a).getState() != null) {
                    this.sbTmp.append(".").append(((InteractiveActor)a).getState());
                }
                this.unprojectTmp.set(r.getX(), r.getY(), 0.0f);
                this.w.getSceneCamera().scene2screen(this.viewport, this.unprojectTmp);
                this.skin.getFont("debug").draw((Batch)batch, (CharSequence)this.sbTmp.toString(), this.unprojectTmp.x, this.unprojectTmp.y);
            }
        }
    }
}

