/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.ui.BladeScreen;
import com.bladecoder.engine.ui.Pointer;
import com.bladecoder.engine.ui.Recorder;
import com.bladecoder.engine.ui.SceneScreen;
import com.bladecoder.engine.ui.TesterBot;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.ui.defaults.ScreenControllerHandler;
import com.bladecoder.engine.util.Config;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.EngineLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class DebugScreen
implements BladeScreen {
    private UI ui;
    private Stage stage;
    private TextField speedText;
    private SelectBox<String> recordings;
    private SelectBox<String> scenes;
    private TextField recFilename;
    private TextButton rec;
    private TextField testerTimeConf;
    private TextField inSceneTimeConf;
    private TextField testerExcludeList;
    private Pointer pointer;
    private ScreenControllerHandler controller;
    Table table;

    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
        this.controller.update(delta);
    }

    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
        this.pointer.resize();
        this.table.invalidate();
    }

    public void dispose() {
        if (this.stage != null) {
            this.stage.dispose();
            this.stage = null;
        }
    }

    public void show() {
        FileHandle[] testFiles2;
        float size = DPIUtils.getPrefButtonSize();
        float margin = DPIUtils.getMarginSize();
        this.stage = new Stage((Viewport)new ScreenViewport());
        this.table = new Table(this.ui.getSkin());
        this.table.setFillParent(true);
        this.table.left().top();
        this.table.pad(margin);
        this.table.addListener((EventListener)new InputListener(){

            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 111 || keycode == 4) {
                    DebugScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                }
                return true;
            }
        });
        this.stage.setKeyboardFocus((Actor)this.table);
        this.controller = new ScreenControllerHandler(this.ui, this.stage, this.stage.getViewport());
        Button back = new Button(this.ui.getSkin(), "back");
        back.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                DebugScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
            }
        });
        Label title = new Label((CharSequence)"DEBUG SCREEN", this.ui.getSkin(), "title");
        Table header = new Table();
        header.padBottom(margin);
        Container cont = new Container((Actor)back);
        cont.size(size);
        header.add((Actor)cont);
        header.add((Actor)title).fillX().expandX().left();
        this.table.add((Actor)header).colspan(3).fillX().expandX().left();
        this.speedText = new TextField(Float.toString(((SceneScreen)this.ui.getScreen(UI.Screens.SCENE_SCREEN)).getSpeed()), this.ui.getSkin());
        TextButton speedButton = new TextButton("Set Speed", this.ui.getSkin());
        speedButton.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                SceneScreen scnScr = (SceneScreen)DebugScreen.this.ui.getScreen(UI.Screens.SCENE_SCREEN);
                scnScr.setSpeed(Float.parseFloat(DebugScreen.this.speedText.getText()));
            }
        });
        speedButton.pad(2.0f, 3.0f, 2.0f, 3.0f);
        HorizontalGroup sGroup = new HorizontalGroup();
        sGroup.space(10.0f);
        sGroup.addActor((Actor)this.speedText);
        sGroup.addActor((Actor)speedButton);
        this.table.row().pad(5.0f).align(8);
        this.table.add((Actor)new Label((CharSequence)"Game Speed: ", this.ui.getSkin(), "debug"));
        this.table.add((Actor)sGroup);
        Recorder r = this.ui.getRecorder();
        TextButton play = new TextButton(r.isPlaying() ? "Stop" : "Play", this.ui.getSkin());
        this.rec = new TextButton(r.isRecording() ? "Stop Rec" : "Rec", this.ui.getSkin());
        play.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                Recorder r = DebugScreen.this.ui.getRecorder();
                if (!r.isPlaying()) {
                    r.setFilename((String)DebugScreen.this.recordings.getSelected());
                    r.load();
                    r.setPlaying(true);
                    DebugScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                } else {
                    r.setPlaying(false);
                    DebugScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                }
            }
        });
        this.rec.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                Recorder r = DebugScreen.this.ui.getRecorder();
                if (r.isPlaying()) {
                    r.setPlaying(false);
                }
                if (!r.isRecording()) {
                    r.setFilename(DebugScreen.this.recFilename.getText());
                }
                r.setRecording(!r.isRecording());
                DebugScreen.this.rec.setText(r.isRecording() ? "Stop Rec" : "Rec");
                if (r.isRecording()) {
                    DebugScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                }
            }
        });
        this.recordings = new SelectBox(this.ui.getSkin());
        String[] testFiles = EngineAssetManager.getInstance().listAssetFiles("tests");
        ArrayList<String> al = new ArrayList<String>();
        for (String file : testFiles) {
            if (!file.endsWith(".verbs.rec")) continue;
            al.add(file.substring(0, file.indexOf(".verbs.rec")));
        }
        for (FileHandle file : testFiles2 = EngineAssetManager.getInstance().getUserFolder().list()) {
            if (!file.name().endsWith(".verbs.rec")) continue;
            al.add(file.name().substring(0, file.name().indexOf(".verbs.rec")));
        }
        this.recordings.setItems((Object[])al.toArray(new String[al.size()]));
        play.pad(2.0f, 3.0f, 2.0f, 3.0f);
        this.rec.pad(2.0f, 3.0f, 2.0f, 3.0f);
        this.recFilename = new TextField(r.getFileName(), this.ui.getSkin());
        HorizontalGroup rGroup = new HorizontalGroup();
        rGroup.space(10.0f);
        rGroup.addActor(this.recordings);
        rGroup.addActor((Actor)play);
        rGroup.addActor((Actor)new Label((CharSequence)"Rec. Filename", this.ui.getSkin(), "debug"));
        rGroup.addActor((Actor)this.recFilename);
        rGroup.addActor((Actor)this.rec);
        this.table.row().pad(5.0f).align(8);
        this.table.add((Actor)new Label((CharSequence)"Game Recording: ", this.ui.getSkin(), "debug"));
        this.table.add((Actor)rGroup);
        this.table.row().pad(5.0f).align(8);
        this.table.add((Actor)new Label((CharSequence)"Load Chapter: ", this.ui.getSkin(), "debug"));
        HorizontalGroup chGroup = new HorizontalGroup();
        chGroup.space(10.0f);
        final TextField chapter = new TextField("", this.ui.getSkin());
        chGroup.addActor((Actor)chapter);
        TextButton loadButton = new TextButton("Load", this.ui.getSkin());
        loadButton.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                String c = chapter.getText();
                if (!c.isEmpty()) {
                    try {
                        DebugScreen.this.ui.getWorld().getSerializer().loadChapter(c, null, true);
                        DebugScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                    }
                    catch (IOException e) {
                        EngineLogger.error("Loading chapter.", e);
                    }
                }
            }
        });
        chGroup.addActor((Actor)loadButton);
        this.table.add((Actor)chGroup);
        final TextButton testScene = new TextButton("Run Test Verb", this.ui.getSkin(), "toggle");
        final TextButton initScene = new TextButton("Init", this.ui.getSkin(), "toggle");
        initScene.setChecked(true);
        TextButton go = new TextButton("Go", this.ui.getSkin());
        go.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                DebugScreen.this.ui.getWorld().setCutMode(false);
                DebugScreen.this.ui.getWorld().resume();
                if (testScene.isChecked()) {
                    DebugScreen.this.ui.getWorld().setTestScene((String)DebugScreen.this.scenes.getSelected());
                }
                DebugScreen.this.ui.getWorld().setCurrentScene((String)DebugScreen.this.scenes.getSelected(), initScene.isChecked(), null);
                DebugScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
            }
        });
        go.pad(2.0f, 3.0f, 2.0f, 3.0f);
        this.scenes = new SelectBox(this.ui.getSkin());
        Object[] scnArray = this.ui.getWorld().getScenes().keySet().toArray(new String[0]);
        Arrays.sort(scnArray);
        this.scenes.setItems(scnArray);
        HorizontalGroup scGroup = new HorizontalGroup();
        scGroup.space(10.0f);
        scGroup.addActor(this.scenes);
        scGroup.addActor((Actor)go);
        scGroup.addActor((Actor)testScene);
        scGroup.addActor((Actor)initScene);
        this.table.row().pad(5.0f).align(8);
        this.table.add((Actor)new Label((CharSequence)"Go to Scene: ", this.ui.getSkin(), "debug"));
        this.table.add((Actor)scGroup);
        TesterBot bot = this.ui.getTesterBot();
        TextButton runBot = new TextButton(bot.isEnabled() ? "Stop" : "Run", this.ui.getSkin());
        runBot.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                TesterBot bot = DebugScreen.this.ui.getTesterBot();
                bot.setMaxWaitInverval(Float.parseFloat(DebugScreen.this.testerTimeConf.getText()));
                bot.setInSceneTime(Float.parseFloat(DebugScreen.this.inSceneTimeConf.getText()));
                bot.setExcludeList(DebugScreen.this.testerExcludeList.getText());
                bot.setEnabled(!bot.isEnabled());
                DebugScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
            }
        });
        runBot.pad(2.0f, 3.0f, 2.0f, 3.0f);
        this.testerTimeConf = new TextField(Float.toString(bot.getMaxWaitInverval()), this.ui.getSkin());
        this.inSceneTimeConf = new TextField(Float.toString(bot.getInSceneTime()), this.ui.getSkin());
        this.testerExcludeList = new TextField(bot.getExcludeList(), this.ui.getSkin());
        TextButton testerLeaveConf = new TextButton("Leave", this.ui.getSkin(), "toggle");
        testerLeaveConf.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                TesterBot bot;
                bot.setRunLeaveVerbs(!(bot = DebugScreen.this.ui.getTesterBot()).isRunLeaveVerbs());
            }
        });
        testerLeaveConf.setChecked(bot.isRunLeaveVerbs());
        TextButton testerGotoConf = new TextButton("Goto", this.ui.getSkin(), "toggle");
        testerGotoConf.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                TesterBot bot;
                bot.setRunGoto(!(bot = DebugScreen.this.ui.getTesterBot()).isRunGoto());
            }
        });
        testerGotoConf.setChecked(bot.isRunGoto());
        TextButton testerPassText = new TextButton("Pass Texts", this.ui.getSkin(), "toggle");
        testerPassText.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                TesterBot bot;
                bot.setPassTexts(!(bot = DebugScreen.this.ui.getTesterBot()).isPassTexts());
            }
        });
        testerPassText.setChecked(bot.isPassTexts());
        TextButton testerWaitWhenWalking = new TextButton("Wait When Walking", this.ui.getSkin(), "toggle");
        testerWaitWhenWalking.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                TesterBot bot;
                bot.setWaitWhenWalking(!(bot = DebugScreen.this.ui.getTesterBot()).isWaitWhenWalking());
            }
        });
        testerWaitWhenWalking.setChecked(bot.isWaitWhenWalking());
        HorizontalGroup botGroup = new HorizontalGroup();
        botGroup.space(10.0f);
        botGroup.addActor((Actor)testerLeaveConf);
        botGroup.addActor((Actor)testerGotoConf);
        botGroup.addActor((Actor)testerPassText);
        botGroup.addActor((Actor)testerWaitWhenWalking);
        HorizontalGroup botGroup2 = new HorizontalGroup();
        botGroup2.space(10.0f);
        botGroup2.addActor((Actor)new Label((CharSequence)"Excl. List: ", this.ui.getSkin(), "debug"));
        botGroup2.addActor((Actor)this.testerExcludeList);
        botGroup2.addActor((Actor)new Label((CharSequence)"Interval: ", this.ui.getSkin(), "debug"));
        botGroup2.addActor((Actor)this.testerTimeConf);
        botGroup2.addActor((Actor)new Label((CharSequence)"Scn Time: ", this.ui.getSkin(), "debug"));
        botGroup2.addActor((Actor)this.inSceneTimeConf);
        botGroup2.addActor((Actor)runBot);
        this.table.row().pad(5.0f).align(8);
        this.table.add((Actor)new Label((CharSequence)"Tester Bot: ", this.ui.getSkin(), "debug"));
        this.table.add((Actor)botGroup);
        this.table.row().pad(5.0f).align(8);
        this.table.add();
        this.table.add((Actor)botGroup2);
        String versionString = Config.getInstance().getProperty("title", "title unspecified") + " v" + Config.getInstance().getProperty("version", "unspecified") + "\nBlade Engine: v" + Config.getInstance().getProperty("bladeEngineVersion", "unspecified") + "\nlibGdx: v" + Config.getInstance().getProperty("gdxVersion", "unspecified") + "\nRoboVM: v" + Config.getInstance().getProperty("roboVMVersion", "unspecified") + "\n";
        Label version = new Label((CharSequence)versionString, this.ui.getSkin(), "debug");
        version.setColor(Color.LIGHT_GRAY);
        Table versionStack = new Table();
        versionStack.defaults().pad(DPIUtils.getSpacing());
        versionStack.pad(0.0f);
        versionStack.add((Actor)version);
        versionStack.bottom().left();
        versionStack.setFillParent(true);
        versionStack.pack();
        this.table.row();
        this.table.add((Actor)versionStack).colspan(3).left();
        this.table.pack();
        ScrollPane scrollPane = new ScrollPane((Actor)this.table);
        scrollPane.setFillParent(true);
        this.stage.addActor((Actor)scrollPane);
        this.pointer = new Pointer(this.ui);
        this.stage.addActor((Actor)this.pointer);
        Gdx.input.setInputProcessor((InputProcessor)this.stage);
    }

    public void hide() {
        this.dispose();
    }

    public void pause() {
    }

    public void resume() {
    }

    @Override
    public void setUI(UI ui) {
        this.ui = ui;
    }
}

