/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.ui.BladeScreen;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.ui.defaults.DefaultSceneScreen;
import com.bladecoder.engine.ui.defaults.ScreenControllerHandler;
import com.bladecoder.engine.util.Config;
import java.text.MessageFormat;
import java.util.Locale;

public class HelpScreen
extends ScreenAdapter
implements BladeScreen {
    private static final String PIE_FILENAME = "ui/helpPie";
    private static final String TWO_BUTTONS_FILENAME = "ui/helpDesktop";
    private static final String SINGLE_CLICK_FILENAME = "ui/helpDesktop";
    private Texture tex;
    private UI ui;
    private String localeFilename;
    private final Viewport viewport;
    private ScreenControllerHandler controller;
    private final InputProcessor inputProcessor = new InputAdapter(){

        public boolean keyUp(int keycode) {
            switch (keycode) {
                case 4: 
                case 111: {
                    HelpScreen.this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
                }
            }
            return true;
        }

        public boolean touchUp(int screenX, int screenY, int pointer, int button) {
            HelpScreen.this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
            return true;
        }
    };

    public HelpScreen() {
        this.viewport = new FitViewport((float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getWidth() * 9.0f / 16.0f);
    }

    public void render(float delta) {
        SpriteBatch batch = this.ui.getBatch();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        batch.setProjectionMatrix(this.viewport.getCamera().combined);
        batch.begin();
        batch.draw(this.tex, 0.0f, 0.0f, (float)this.viewport.getScreenWidth(), (float)this.viewport.getScreenHeight());
        batch.end();
        this.controller.update(delta);
    }

    public void resize(int width, int height) {
        float aspect = width / height;
        float bgAspect = (float)this.tex.getWidth() / (float)this.tex.getHeight();
        if (aspect < bgAspect) {
            this.viewport.setWorldSize((float)width, (float)((int)((float)width / bgAspect)));
        } else {
            this.viewport.setWorldSize((float)((int)((float)height * bgAspect)), (float)height);
        }
        this.viewport.update(width, height, true);
    }

    public void dispose() {
        if (this.tex != null) {
            this.tex.dispose();
            this.tex = null;
        }
    }

    public void show() {
        Locale locale = this.ui.getWorld().getI18N().getCurrentLocale();
        String filename = null;
        DefaultSceneScreen.UIModes uiMode = DefaultSceneScreen.UIModes.valueOf(Config.getInstance().getProperty("ui_mode", "TWO_BUTTONS").toUpperCase(Locale.ENGLISH));
        if (this.ui.getInputMode() == UI.InputMode.TOUCHPANEL && uiMode == DefaultSceneScreen.UIModes.TWO_BUTTONS) {
            uiMode = DefaultSceneScreen.UIModes.PIE;
        }
        switch (uiMode) {
            case PIE: {
                filename = PIE_FILENAME;
                break;
            }
            case SINGLE_CLICK: {
                filename = "ui/helpDesktop";
                break;
            }
            case TWO_BUTTONS: {
                filename = "ui/helpDesktop";
            }
        }
        this.localeFilename = MessageFormat.format("{0}_{1}.png", filename, locale.getLanguage());
        if (!EngineAssetManager.getInstance().assetExists(this.localeFilename)) {
            this.localeFilename = MessageFormat.format("{0}.png", filename);
        }
        this.tex = new Texture(EngineAssetManager.getInstance().getResAsset(this.localeFilename));
        this.tex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Gdx.input.setInputProcessor(this.inputProcessor);
        this.controller = new ScreenControllerHandler(this.ui, null, this.viewport){

            @Override
            protected boolean buttonUp(Controller controller, int buttonCode) {
                HelpScreen.this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
                return true;
            }
        };
    }

    public void hide() {
        this.dispose();
    }

    @Override
    public void setUI(UI ui) {
        this.ui = ui;
    }
}

