/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.RectangleRenderer;
import com.bladecoder.engine.util.UIUtils;

public class HotspotsDrawer {
    private final UI ui;
    private final Viewport viewport;
    private final GlyphLayout textLayout = new GlyphLayout();
    private final Vector3 unprojectTmp = new Vector3();

    public HotspotsDrawer(UI ui, Viewport viewport) {
        this.ui = ui;
        this.viewport = viewport;
    }

    public void draw(SpriteBatch batch, boolean showDesc) {
        World w = this.ui.getWorld();
        for (BaseActor a : w.getCurrentScene().getActors().values()) {
            InteractiveActor ia;
            if (!(a instanceof InteractiveActor) || !a.isVisible() || a == w.getCurrentScene().getPlayer() || !(ia = (InteractiveActor)a).canInteract()) continue;
            Polygon p = a.getBBox();
            if (p == null) {
                EngineLogger.error("ERROR DRAWING HOTSPOT FOR: " + a.getId());
            }
            Rectangle r = a.getBBox().getBoundingRectangle();
            this.unprojectTmp.set(r.getX() + r.getWidth() / 2.0f, r.getY() + r.getHeight() / 2.0f, 0.0f);
            w.getSceneCamera().scene2screen(this.viewport, this.unprojectTmp);
            if (!showDesc || ia.getDesc() == null) {
                Drawable drawable;
                float size = DPIUtils.ICON_SIZE * DPIUtils.getSizeMultiplier();
                if (ia.getVerb("leave") != null) {
                    drawable = (TransformDrawable)this.ui.getSkin().getDrawable("leave");
                    drawable.draw((Batch)batch, this.unprojectTmp.x - size / 2.0f, this.unprojectTmp.y - size / 2.0f, size / 2.0f, size / 2.0f, size, size, 1.0f, 1.0f, UIUtils.calcLeaveArrowRotation(this.viewport, ia));
                    continue;
                }
                drawable = this.ui.getSkin().getDrawable("hotspot");
                if (drawable == null) continue;
                drawable.draw((Batch)batch, this.unprojectTmp.x - size / 2.0f, this.unprojectTmp.y - size / 2.0f, size, size);
                continue;
            }
            BitmapFont font = this.ui.getSkin().getFont("desc");
            String desc = ia.getDesc();
            if (desc.charAt(0) == '@') {
                desc = w.getI18N().getString(desc.substring(1));
            }
            this.textLayout.setText(font, (CharSequence)desc);
            float textX = this.unprojectTmp.x - this.textLayout.width / 2.0f;
            float textY = this.unprojectTmp.y + this.textLayout.height;
            RectangleRenderer.draw((Batch)batch, textX - 8.0f, textY - this.textLayout.height - 8.0f, this.textLayout.width + 16.0f, this.textLayout.height + 16.0f, Color.BLACK);
            font.draw((Batch)batch, this.textLayout, textX, textY);
        }
    }
}

