/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.ui.BladeScreen;
import com.bladecoder.engine.ui.UI;

public class InitScreen
extends ScreenAdapter
implements BladeScreen {
    private static final String FILENAME = "ui/blade_logo.png";
    private static final float FADE_TIME = 0.6f;
    private static final float SCREEN_TIME = 0.8f;
    private Texture tex;
    private UI ui;
    private float time;
    private float fadeTime;
    private float scale = 1.0f;
    private final Viewport viewport = new ScreenViewport();

    public void render(float delta) {
        SpriteBatch batch = this.ui.getBatch();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        batch.setProjectionMatrix(this.viewport.getCamera().combined);
        batch.begin();
        if (this.time > 2.0f) {
            batch.setColor(Color.WHITE);
            this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
            batch.end();
            return;
        }
        if (this.time > 1.4000001f) {
            batch.setColor(1.0f, 1.0f, 1.0f, 1.0f - this.fadeTime / 0.6f);
        } else if (this.time < 0.6f) {
            batch.setColor(1.0f, 1.0f, 1.0f, this.fadeTime / 0.6f);
        } else {
            this.fadeTime = 0.0f;
        }
        int viewportW = this.viewport.getScreenWidth();
        int viewportH = this.viewport.getScreenHeight();
        float texW = (float)this.tex.getWidth() * this.scale;
        float texH = (float)this.tex.getHeight() * this.scale;
        batch.draw(this.tex, ((float)viewportW - texW) / 2.0f, ((float)viewportH - texH) / 2.0f, texW, texH);
        batch.setColor(Color.WHITE);
        this.time += delta;
        this.fadeTime += delta;
        batch.end();
    }

    public void resize(int width, int height) {
        this.viewport.update(width, height, true);
        this.scale = (float)width / (float)EngineAssetManager.getInstance().getResolution().portraitWidth;
    }

    protected void retrieveAssets() {
        this.tex = new Texture(EngineAssetManager.getInstance().getResAsset(FILENAME));
        this.tex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
    }

    public void dispose() {
        if (this.tex != null) {
            this.tex.dispose();
            this.tex = null;
        }
    }

    public void show() {
        this.fadeTime = 0.0f;
        this.time = 0.0f;
        Gdx.input.setInputProcessor(null);
        this.retrieveAssets();
    }

    public void hide() {
        this.dispose();
    }

    @Override
    public void setUI(UI ui) {
        this.ui = ui;
    }
}

