/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.ui.AnimButton;
import com.bladecoder.engine.ui.InventoryUI;
import com.bladecoder.engine.util.DPIUtils;

public class InventoryButton
extends AnimButton {
    private final InventoryUI inventory;
    private final World world;
    private int numItems = Integer.MAX_VALUE;

    private static Button.ButtonStyle getDefaultStyle(Skin skin) {
        InventoryUI.InventoryUIStyle inventoryUIStyle = (InventoryUI.InventoryUIStyle)skin.get(InventoryUI.InventoryUIStyle.class);
        Button.ButtonStyle inventoryButtonStyle = inventoryUIStyle.inventoryButtonStyle;
        if (inventoryButtonStyle == null) {
            inventoryButtonStyle = (Button.ButtonStyle)skin.get("inventory", Button.ButtonStyle.class);
        }
        return inventoryButtonStyle;
    }

    public InventoryButton(Skin skin, World w, InventoryUI inv) {
        super(InventoryButton.getDefaultStyle(skin));
        this.inventory = inv;
        this.world = w;
        this.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!InventoryButton.this.inventory.isVisible()) {
                    InventoryButton.this.inventory.show();
                } else {
                    InventoryButton.this.inventory.hide();
                }
            }
        });
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.numItems < this.world.getInventory().getNumItems()) {
            this.addAction((Action)Actions.repeat((int)4, (Action)Actions.sequence((Action)Actions.moveBy((float)20.0f, (float)0.0f, (float)0.06f), (Action)Actions.moveBy((float)-20.0f, (float)0.0f, (float)0.06f))));
        }
        this.numItems = this.world.getInventory().getNumItems();
    }

    public void resize(int width, int height) {
        float size = DPIUtils.getPrefButtonSize();
        float margin = DPIUtils.getMarginSize();
        this.setSize(size, size);
        InventoryUI.InventoryPos inventoryPos = this.inventory.getInventoryPos();
        switch (inventoryPos) {
            case TOP: {
                this.setPosition(margin, (float)height - margin - this.getHeight());
                break;
            }
            case LEFT: {
                this.setPosition(margin, margin);
                break;
            }
            case RIGHT: {
                this.setPosition((float)width - margin - this.getWidth(), margin);
                break;
            }
            case DOWN: 
            case CENTER: {
                this.setPosition(margin, margin);
                break;
            }
        }
    }
}

