/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.ui.BladeScreen;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.util.RectangleRenderer;

public class LoadingScreen
extends ScreenAdapter
implements BladeScreen {
    private static final float INIT_TIME_SEG = 1.0f;
    private int pos = 0;
    private int numSquares = 3;
    private float x;
    private float y;
    private float squareWidth = 30.0f;
    private float squareHeight = 30.0f;
    private float margin = 10.0f;
    private float initTime = 0.0f;
    private float delta = 0.0f;
    private UI ui;
    private final Viewport viewport = new ScreenViewport();

    public void render(float delta) {
        if (!EngineAssetManager.getInstance().isLoading()) {
            this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
            return;
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        if (this.initTime < 1.0f) {
            this.initTime += delta;
            return;
        }
        SpriteBatch batch = this.ui.getBatch();
        batch.setProjectionMatrix(this.viewport.getCamera().combined);
        batch.begin();
        this.update(delta);
        for (int i = 0; i < this.numSquares; ++i) {
            Color color = i == this.pos ? Color.WHITE : Color.GRAY;
            RectangleRenderer.draw((Batch)this.ui.getBatch(), this.x + (float)i * (this.squareWidth + this.margin), this.y, this.squareWidth, this.squareHeight, color);
        }
        batch.end();
    }

    private void update(float d) {
        this.delta += d;
        if ((double)this.delta > 0.4) {
            this.pos = (this.pos + 1) % this.numSquares;
            this.delta = 0.0f;
        }
    }

    public void resize(int width, int height) {
        this.viewport.update(width, height, true);
        this.x = (this.viewport.getWorldWidth() - (this.squareWidth * (float)this.numSquares + this.margin * (float)(this.numSquares - 1))) / 2.0f;
        this.y = (this.viewport.getWorldHeight() - this.squareHeight) / 2.0f;
    }

    public void show() {
        Gdx.input.setInputProcessor(null);
        this.initTime = 0.0f;
        this.delta = 0.0f;
    }

    @Override
    public void setUI(UI ui) {
        this.ui = ui;
    }
}

