/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.SnapshotArray;

public class PagedScrollPane
extends ScrollPane {
    private boolean wasPanDragFling = false;
    private Table content;

    public PagedScrollPane() {
        super(null);
        this.setup();
    }

    public PagedScrollPane(Skin skin) {
        super(null, skin);
        this.setup();
    }

    public PagedScrollPane(Skin skin, String styleName) {
        super(null, skin, styleName);
        this.setup();
    }

    public PagedScrollPane(Actor widget, ScrollPane.ScrollPaneStyle style) {
        super(null, style);
        this.setup();
    }

    private void setup() {
        this.content = new Table();
        this.content.defaults().space(50.0f);
        super.setActor((Actor)this.content);
    }

    public void addPages(Actor ... pages) {
        for (Actor page : pages) {
            this.content.add(page).expandY().fillY();
        }
    }

    public void addPage(Actor page) {
        this.content.add(page).expandY().fillY();
    }

    public void act(float delta) {
        super.act(delta);
        if (this.wasPanDragFling && !this.isPanning() && !this.isDragging() && !this.isFlinging()) {
            this.wasPanDragFling = false;
            this.scrollToPage();
        } else if (this.isPanning() || this.isDragging() || this.isFlinging()) {
            this.wasPanDragFling = true;
        }
    }

    public void setWidth(float width) {
        super.setWidth(width);
        if (this.content != null) {
            for (Cell cell : this.content.getCells()) {
                cell.width(width);
            }
            this.content.invalidate();
        }
    }

    public void setPageSpacing(float pageSpacing) {
        if (this.content != null) {
            this.content.defaults().space(pageSpacing);
            for (Cell cell : this.content.getCells()) {
                cell.space(pageSpacing);
            }
            this.content.invalidate();
        }
    }

    private void scrollToPage() {
        float maxX;
        float width = this.getWidth();
        float scrollX = this.getScrollX();
        if (scrollX >= (maxX = this.getMaxX()) || scrollX <= 0.0f) {
            return;
        }
        SnapshotArray pages = this.content.getChildren();
        float pageX = 0.0f;
        float pageWidth = 0.0f;
        if (pages.size > 0) {
            Actor a;
            Array.ArrayIterator arrayIterator = pages.iterator();
            while (arrayIterator.hasNext() && !((double)scrollX < (double)(pageX = (a = (Actor)arrayIterator.next()).getX()) + (double)(pageWidth = a.getWidth()) * 0.5)) {
            }
            this.setScrollX(MathUtils.clamp((float)(pageX - (width - pageWidth) / 2.0f), (float)0.0f, (float)maxX));
        }
    }

    public void scrollToPage(int page) {
        float width = this.getWidth();
        float scrollX = this.getScrollX();
        float maxX = this.getMaxX();
        Actor a = (Actor)this.content.getChildren().get(page);
        float pageX = 0.0f;
        float pageWidth = 0.0f;
        pageX = a.getX();
        pageWidth = a.getWidth();
        this.setScrollX(MathUtils.clamp((float)(pageX - (width - pageWidth) / 2.0f), (float)0.0f, (float)maxX));
        this.updateVisualScroll();
        this.invalidate();
        this.layout();
    }
}

