/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.ui.AnimButton;
import com.bladecoder.engine.ui.SceneScreen;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.ui.defaults.ScreenControllerHandler;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.RectangleRenderer;

public class PieMenu
extends Group {
    private BitmapFont font;
    private Button lookatButton;
    private Button talktoButton;
    private Button pickupButton;
    private float x = 0.0f;
    private float y = 0.0f;
    private InteractiveActor iActor = null;
    private final SceneScreen sceneScreen;
    private int viewportWidth;
    private int viewportHeight;
    private final GlyphLayout layout = new GlyphLayout();
    private String desc = null;

    public PieMenu(SceneScreen scr) {
        this.sceneScreen = scr;
        this.font = scr.getUI().getSkin().getFont("desc");
        this.lookatButton = new AnimButton(scr.getUI().getSkin(), "pie_lookat");
        this.addActor((Actor)this.lookatButton);
        this.lookatButton.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (PieMenu.this.iActor != null && PieMenu.this.iActor.canInteract()) {
                    PieMenu.this.sceneScreen.runVerb(PieMenu.this.iActor, "lookat", null);
                }
                PieMenu.this.hide();
            }
        });
        this.talktoButton = new AnimButton(scr.getUI().getSkin(), "pie_talkto");
        this.addActor((Actor)this.talktoButton);
        this.talktoButton.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (PieMenu.this.iActor != null && PieMenu.this.iActor.canInteract()) {
                    PieMenu.this.sceneScreen.runVerb(PieMenu.this.iActor, "talkto", null);
                }
                PieMenu.this.hide();
            }
        });
        this.pickupButton = new AnimButton(scr.getUI().getSkin(), "pie_pickup");
        this.addActor((Actor)this.pickupButton);
        this.pickupButton.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (PieMenu.this.iActor != null) {
                    PieMenu.this.sceneScreen.runVerb(PieMenu.this.iActor, "pickup", null);
                }
                PieMenu.this.hide();
            }
        });
    }

    public void draw(Batch batch, float alpha) {
        if (!this.iActor.canInteract()) {
            this.hide();
            return;
        }
        super.draw(batch, alpha);
        String desc = this.iActor.getDesc();
        if (desc != null) {
            float margin = DPIUtils.UI_SPACE;
            float textX = this.x - this.layout.width / 2.0f;
            float textY = this.y - this.layout.height - DPIUtils.UI_SPACE;
            if (textX < 0.0f) {
                textX = 0.0f;
            }
            RectangleRenderer.draw(batch, textX - margin, textY - this.layout.height - margin, this.layout.width + margin * 2.0f, this.layout.height + margin * 2.0f, Color.BLACK);
            this.font.draw(batch, this.layout, textX, textY);
        }
    }

    public void hide() {
        this.setVisible(false);
        this.iActor = null;
    }

    public void show(InteractiveActor a, float x, float y) {
        Button rightButton;
        this.setVisible(true);
        this.x = x;
        this.y = y;
        this.iActor = a;
        this.desc = this.iActor.getDesc();
        if (this.desc != null) {
            if (this.desc.charAt(0) == '@') {
                this.desc = this.sceneScreen.getWorld().getI18N().getString(this.desc.substring(1));
            }
            this.layout.setText(this.font, (CharSequence)this.desc);
        }
        if (a.getVerb("talkto") != null) {
            this.talktoButton.setVisible(true);
            this.pickupButton.setVisible(false);
            rightButton = this.talktoButton;
        } else {
            this.talktoButton.setVisible(false);
            this.pickupButton.setVisible(true);
            rightButton = this.pickupButton;
        }
        float margin = DPIUtils.getMarginSize();
        if (x < this.lookatButton.getWidth() + margin) {
            this.x = this.lookatButton.getWidth() + margin;
        } else if (x > (float)this.viewportWidth - this.lookatButton.getWidth() - margin) {
            this.x = (float)this.viewportWidth - this.lookatButton.getWidth() - margin;
        }
        if (y < margin) {
            this.y = margin;
        } else if (y > (float)this.viewportHeight - this.lookatButton.getHeight() - margin) {
            this.y = (float)this.viewportHeight - this.lookatButton.getHeight() - margin;
        }
        this.lookatButton.setPosition(this.x - this.lookatButton.getWidth() / 2.0f, this.y - this.lookatButton.getHeight() / 2.0f);
        this.lookatButton.addAction((Action)Actions.sequence((Action)Actions.moveTo((float)(this.x - this.lookatButton.getWidth() - margin / 2.0f), (float)(this.y + margin), (float)0.1f), (Action)Actions.run((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PieMenu.this.sceneScreen.getUI().getInputMode() == UI.InputMode.GAMEPAD) {
                    ScreenControllerHandler.cursorToActor((Actor)PieMenu.this.lookatButton);
                }
            }
        })));
        rightButton.setPosition(this.x - this.lookatButton.getWidth() / 2.0f, this.y - this.lookatButton.getHeight() / 2.0f);
        rightButton.addAction((Action)Actions.moveTo((float)(this.x + margin / 2.0f), (float)(this.y + margin), (float)0.1f));
    }

    public void resize(int width, int height) {
        this.viewportWidth = width;
        this.viewportHeight = height;
        this.setBounds(0.0f, 0.0f, width, height);
        float size = DPIUtils.getPrefButtonSize();
        this.lookatButton.setSize(size, size);
        this.talktoButton.setSize(size, size);
        this.pickupButton.setSize(size, size);
    }
}

