/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.ObjectMap;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.ui.ITextManagerUI;
import com.bladecoder.engine.util.Config;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.EngineLogger;

public class TextManagerUI
extends Actor
implements ITextManagerUI {
    private static final float PADDING = DPIUtils.getMarginSize();
    private final Vector3 unprojectTmp = new Vector3();
    private ObjectMap<String, TextManagerUIStyle> styles;
    private Text text;
    private final GlyphLayout layout = new GlyphLayout();
    private float fontX = 0.0f;
    private TextureAtlas.AtlasRegion charIcon = null;
    private TextManagerUIStyle style;
    private float maxWidth;
    private final World world;

    public TextManagerUI(Skin skin, World w) {
        this.world = w;
        this.setTouchable(Touchable.disabled);
        this.styles = skin.getAll(TextManagerUIStyle.class);
        for (TextManagerUIStyle style : this.styles.values()) {
            style.font.getData().markupEnabled = true;
        }
        this.setVisible(false);
    }

    @Override
    public void setText(Text t) {
        this.text = t;
        if (t == null && this.isVisible()) {
            this.setVisible(false);
        } else if (t != null && !this.isVisible()) {
            this.setVisible(true);
        }
        if (this.isVisible()) {
            Color color;
            this.style = this.getStyle(this.text);
            Color color2 = color = this.text.color != null ? this.text.color : this.style.defaultColor;
            if (color == null) {
                color = Color.BLACK;
            }
            this.maxWidth = Math.min((float)this.getStage().getViewport().getScreenWidth() - PADDING * 4.0f, this.style.font.getXHeight() * (float)(this.text.type == Text.Type.TALK ? this.style.maxTalkCharWidth : this.style.maxCharWidth));
            this.layout.setText(this.style.font, (CharSequence)this.text.str, color, this.maxWidth, 1, true);
            this.setSize(this.layout.width + PADDING * 2.0f, this.layout.height + PADDING * 2.0f);
            this.calcPos();
        }
    }

    private void calcPos() {
        float posx = this.text.x;
        float posy = this.text.y;
        this.unprojectTmp.set(posx, posy, 0.0f);
        this.world.getSceneCamera().scene2screen(this.getStage().getViewport(), this.unprojectTmp);
        if (posx == -1.0f || posx == -2.0f) {
            posx = this.getStage().getViewport().getScreenWidth() / 2;
            this.fontX = this.getStage().getViewport().getScreenWidth() / 2;
        } else {
            posx = this.unprojectTmp.x;
            this.fontX = posx + (this.layout.width - this.maxWidth) / 2.0f;
        }
        if (posy == -1.0f) {
            posy = ((float)this.getStage().getViewport().getScreenHeight() - this.layout.height) / 2.0f;
        } else if (posy == -2.0f) {
            posy = (float)this.getStage().getViewport().getScreenHeight() * this.style.subtitlePosPercent - this.layout.height;
            if (posy < 0.0f) {
                posy = PADDING;
            }
        } else {
            posy = this.unprojectTmp.y;
            if (this.text.type != Text.Type.TALK) {
                posy -= this.layout.height;
            }
        }
        if (this.text.type == Text.Type.SUBTITLE && !Config.getInstance().getProperty("character_icon_atlas", "").equals("") && this.text.actorId != null) {
            this.charIcon = EngineAssetManager.getInstance().getRegion(Config.getInstance().getProperty("character_icon_atlas", null), this.text.actorId);
            if (this.charIcon != null) {
                float scale = (float)this.getStage().getViewport().getScreenHeight() / (float)this.world.getHeight();
                float iconPosY = (float)this.getStage().getViewport().getScreenHeight() - (float)this.charIcon.getRegionHeight() * scale - DPIUtils.getMarginSize();
                posy = Math.min(posy, iconPosY);
            }
        } else {
            this.charIcon = null;
        }
        this.setPosition(posx - PADDING, posy - PADDING);
        if (this.text.type == Text.Type.TALK) {
            if (this.style.talkBubble != null) {
                float bubbleHeight = DPIUtils.getTouchMinSize() * this.style.bubbleSize * 0.25f;
                this.setY(this.getY() + bubbleHeight + PADDING + DPIUtils.getSpacing());
            } else {
                this.setY(this.getY() + PADDING + DPIUtils.getSpacing());
            }
        }
        this.setX(this.getX() - this.layout.width / 2.0f);
        this.fontX = posx - this.maxWidth / 2.0f;
        if (this.getX() < 0.0f && this.getX() > -this.getWidth()) {
            this.setX(0.0f + PADDING);
            this.fontX = this.getX() + PADDING + (this.layout.width - this.maxWidth) / 2.0f;
        } else if (this.getX() + this.getWidth() > (float)this.getStage().getViewport().getScreenWidth() && this.getX() + this.getWidth() < (float)this.getStage().getViewport().getScreenWidth() + this.getWidth()) {
            this.setX((float)this.getStage().getViewport().getScreenWidth() - this.getWidth() - PADDING);
            this.fontX = (float)this.getStage().getViewport().getScreenWidth() - this.layout.width / 2.0f - PADDING * 2.0f - this.maxWidth / 2.0f;
        }
        if (this.getY() + this.getHeight() > (float)this.getStage().getViewport().getScreenHeight()) {
            this.setY((float)this.getStage().getViewport().getScreenHeight() - this.getHeight() - PADDING);
        }
    }

    public void draw(Batch batch, float alpha) {
        if (this.text.type == Text.Type.TALK) {
            this.calcPos();
            if (this.getX() < 0.0f || this.getX() > (float)this.getStage().getViewport().getScreenWidth()) {
                return;
            }
            if (this.style.talkBubble != null) {
                float scale = DPIUtils.getTouchMinSize() * this.style.bubbleSize * 0.25f / this.style.talkBubble.getMinHeight();
                float bubbleX = this.unprojectTmp.x - this.style.talkBubble.getMinWidth() * scale * 0.5f + this.style.bubbledx;
                bubbleX = Math.max(bubbleX, this.getX() + PADDING - this.style.talkBubble.getMinWidth() * scale / 2.0f);
                bubbleX = Math.min(bubbleX, this.getX() + this.getWidth() - PADDING - this.style.talkBubble.getMinWidth() * scale * 0.5f);
                float bubbleY = this.getY() - this.style.talkBubble.getMinHeight() * scale + this.style.bubbledy;
                this.style.talkBubble.draw(batch, bubbleX, bubbleY, this.style.talkBubble.getMinWidth() * scale, this.style.talkBubble.getMinHeight() * scale);
            }
            if (this.style.talkBackground != null) {
                this.style.talkBackground.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
        } else if (this.text.type == Text.Type.SUBTITLE) {
            if (this.style.rectBackground != null) {
                this.style.rectBackground.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
            if (this.charIcon != null) {
                float scale = (float)this.getStage().getViewport().getScreenHeight() / (float)this.world.getHeight();
                batch.draw((TextureRegion)this.charIcon, this.getX() - (float)this.charIcon.getRegionWidth() * scale, this.getY(), (float)this.charIcon.getRegionWidth() * scale, (float)this.charIcon.getRegionHeight() * scale);
            }
        }
        this.style.font.draw(batch, this.layout, this.fontX, this.getY() + PADDING + this.layout.height);
    }

    private TextManagerUIStyle getStyle(Text text) {
        CharacterActor a;
        String key = "default";
        if (text != null && text.style != null && !text.style.isEmpty()) {
            key = text.style;
        } else if (text.actorId != null && (a = (CharacterActor)this.world.getCurrentScene().getActor(text.actorId, false)) != null && a.getTextStyle() != null) {
            key = a.getTextStyle();
        }
        TextManagerUIStyle s = (TextManagerUIStyle)this.styles.get((Object)key);
        if (s == null) {
            EngineLogger.error("TextManagerUIStyle not found: " + key);
            return (TextManagerUIStyle)this.styles.get((Object)"default");
        }
        return s;
    }

    public static class TextManagerUIStyle {
        public Drawable rectBackground;
        public Drawable talkBackground;
        public Drawable talkBubble;
        public BitmapFont font;
        public Color defaultColor;
        public float subtitlePosPercent = 0.9f;
        public float bubbleSize = 1.0f;
        public float bubbledx = 0.0f;
        public float bubbledy = 0.0f;
        public int maxCharWidth = 80;
        public int maxTalkCharWidth = 35;

        public TextManagerUIStyle() {
        }

        public TextManagerUIStyle(TextManagerUIStyle style) {
            this.rectBackground = style.rectBackground;
            this.talkBackground = style.talkBackground;
            this.talkBubble = style.talkBubble;
            this.font = style.font;
            this.defaultColor = style.defaultColor;
            this.subtitlePosPercent = style.subtitlePosPercent;
            this.bubbleSize = style.bubbleSize;
            this.bubbledx = style.bubbledx;
            this.bubbledy = style.bubbledy;
            this.maxCharWidth = style.maxCharWidth;
            this.maxTalkCharWidth = style.maxTalkCharWidth;
        }
    }
}

