/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui.defaults;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.SnapshotArray;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.ui.DialogUI;
import com.bladecoder.engine.ui.InventoryUI;
import com.bladecoder.engine.ui.SceneScreen;
import com.bladecoder.engine.ui.defaults.DefaultSceneScreen;
import com.bladecoder.engine.ui.defaults.ScreenControllerHandler;
import com.bladecoder.engine.util.EngineLogger;
import java.util.ArrayList;

public class SceneControllerHandler
extends ScreenControllerHandler {
    private DefaultSceneScreen dsc;

    public SceneControllerHandler(DefaultSceneScreen dsc) {
        super(dsc.getUI(), dsc.getStage(), dsc.getViewport());
        this.dsc = dsc;
    }

    @Override
    protected boolean buttonUp(Controller controller, int buttonCode) {
        int x = Gdx.input.getX();
        int y = Gdx.input.getY();
        if (this.dsc.getInventoryUI().isDragging() && (buttonCode == controller.getMapping().buttonA || buttonCode == controller.getMapping().buttonB)) {
            this.dsc.getInventoryUI().touchedUp(x, y, SceneScreen.ActionButton.LOOKAT);
            return true;
        }
        if (super.buttonUp(controller, buttonCode)) {
            EngineLogger.debug("> Controller button handled by Stage.");
            return true;
        }
        if (buttonCode == controller.getMapping().buttonA) {
            this.dsc.tap(SceneScreen.ActionButton.LOOKAT, 1);
        } else if (buttonCode == controller.getMapping().buttonB) {
            this.dsc.tap(SceneScreen.ActionButton.ACTION, 1);
        } else if (buttonCode == controller.getMapping().buttonY) {
            this.dsc.tap(SceneScreen.ActionButton.INVENTORY, 1);
        } else if (buttonCode == controller.getMapping().buttonX) {
            if (this.dsc.getInventoryUI().isVisible()) {
                this.dsc.getInventoryUI().hide();
            } else if (this.dsc.getInventoryUI().isDragging()) {
                this.dsc.getInventoryUI().cancelDragging();
            }
        }
        return false;
    }

    @Override
    public void focusNext(ScreenControllerHandler.PointerToNextType type) {
        if (this.dsc.getDialogUI().isVisible()) {
            this.pointerToDialog(type);
        } else if (this.dsc.getInventoryUI().isVisible()) {
            this.pointerToInventory(type);
        } else if (this.dsc.getPie().isVisible()) {
            this.pointerToPie();
        } else {
            this.pointerToSceneActor(this.dsc.getWorld(), type, this.dsc.getViewport());
        }
    }

    private void pointerToInventory(ScreenControllerHandler.PointerToNextType type) {
        InventoryUI inv = this.dsc.getInventoryUI();
        int i = inv.getIndexUnderCursor();
        if (i == -1) {
            inv.cursorToInventoryActor(0);
        } else if (type == ScreenControllerHandler.PointerToNextType.RIGHT) {
            inv.cursorToInventoryActor(++i == this.dsc.getWorld().getInventory().getNumItems() ? 0 : i);
        } else {
            inv.cursorToInventoryActor(--i == -1 ? this.dsc.getWorld().getInventory().getNumItems() - 1 : i);
        }
    }

    private void pointerToDialog(ScreenControllerHandler.PointerToNextType type) {
        Button hit = this.getButtonUnderCursor(this.dsc.getStage());
        DialogUI dialogUI = (DialogUI)this.dsc.getDialogUI();
        SnapshotArray actors = ((Table)dialogUI.getChildren().get(0)).getChildren();
        int idx = 0;
        if (hit != null) {
            idx = actors.indexOf((Object)hit, true);
            if (idx > 0 && type == ScreenControllerHandler.PointerToNextType.LEFT) {
                --idx;
            } else if (idx < actors.size - 1 && type == ScreenControllerHandler.PointerToNextType.RIGHT) {
                ++idx;
            }
        }
        Button target = (Button)actors.get(idx);
        EngineLogger.debug("Final IDX: " + idx + " Button: " + target);
        if (idx == 0 && hit != null && dialogUI.getScrollPercentY() != 0.0f) {
            dialogUI.setScrollPercentY(0.0f);
        } else if (idx == actors.size - 1 && dialogUI.getScrollPercentY() != 1.0f) {
            dialogUI.setScrollPercentY(1.0f);
        } else {
            dialogUI.scrollTo(target.getX(), target.getY(), target.getWidth(), target.getHeight());
        }
        dialogUI.updateVisualScroll();
        dialogUI.invalidate();
        dialogUI.layout();
        SceneControllerHandler.cursorToActor((Actor)target);
        dialogUI.setUpDownVisibility();
    }

    private void pointerToPie() {
        Button hit = this.getButtonUnderCursor(this.dsc.getStage());
        SnapshotArray actors = this.dsc.getPie().getChildren();
        int idx = 0;
        if (hit != null && hit != actors.get(1) && hit != actors.get(2)) {
            idx = ((Actor)actors.get(1)).isVisible() ? 1 : 2;
        }
        Button target = (Button)actors.get(idx);
        SceneControllerHandler.cursorToActor((Actor)target);
    }

    private void pointerToSceneActor(World w, ScreenControllerHandler.PointerToNextType type, Viewport viewport) {
        Vector2 pos;
        ArrayList<Vector2> positions = new ArrayList<Vector2>();
        Vector3 unprojectV = new Vector3();
        float scale = EngineAssetManager.getInstance().getScale();
        InteractiveActor actorUnderCursor = w.getInteractiveActorAtInput(viewport, 0.0f);
        for (InteractiveActor interactiveActor : w.getUIActors().getActors()) {
            if (!interactiveActor.canInteract() || actorUnderCursor == interactiveActor) continue;
            pos = new Vector2();
            interactiveActor.getBBox().getBoundingRectangle().getCenter(pos);
            if (w.getUIActors().getActorAt(pos.x, pos.y) != interactiveActor) continue;
            unprojectV.set(pos.x * scale, pos.y * scale, 0.0f);
            w.getUIActors().getCamera().project(unprojectV, 0.0f, 0.0f, (float)viewport.getScreenWidth(), (float)viewport.getScreenHeight());
            positions.add(pos.set(unprojectV.x, (float)viewport.getScreenHeight() - unprojectV.y));
        }
        for (BaseActor baseActor : w.getCurrentScene().getActors().values()) {
            if (!(baseActor instanceof InteractiveActor) || !((InteractiveActor)baseActor).canInteract() || actorUnderCursor == baseActor) continue;
            pos = new Vector2();
            baseActor.getBBox().getBoundingRectangle().getCenter(pos);
            if (w.getUIActors().getActorAt(pos.x, pos.y) != null || w.getCurrentScene().getInteractiveActorAt(pos.x, pos.y) != baseActor) continue;
            unprojectV.set(pos.x * scale, pos.y * scale, 0.0f);
            w.getCurrentScene().getCamera().project(unprojectV, 0.0f, 0.0f, viewport.getScreenWidth(), viewport.getScreenHeight());
            positions.add(pos.set((float)viewport.getScreenX() + unprojectV.x, (float)(viewport.getScreenY() + viewport.getScreenHeight()) - unprojectV.y));
        }
        this.setNextCursorPosition(positions, type);
    }
}

