/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui.defaults;

import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.bladecoder.engine.ui.InventoryUI;
import com.bladecoder.engine.ui.SceneScreen;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.ui.defaults.DefaultSceneScreen;
import com.bladecoder.engine.ui.defaults.SceneControllerHandler;
import com.bladecoder.engine.ui.defaults.SceneGestureListener;
import com.bladecoder.engine.ui.defaults.ScreenControllerHandler;
import com.bladecoder.engine.util.EngineLogger;
import java.io.IOException;

public class SceneGestureDetector
extends GestureDetector {
    private final DefaultSceneScreen dsc;
    private final SceneControllerHandler sceneControllerHandler;

    public SceneGestureDetector(DefaultSceneScreen dsc, SceneControllerHandler sceneControllerHandler) {
        super((GestureDetector.GestureListener)new SceneGestureListener(dsc));
        this.dsc = dsc;
        this.sceneControllerHandler = sceneControllerHandler;
    }

    public boolean keyUp(int keycode) {
        switch (keycode) {
            case 4: 
            case 82: 
            case 111: {
                this.dsc.showMenu();
                break;
            }
            case 32: {
                if (!UIUtils.ctrl()) break;
                EngineLogger.toggle();
                break;
            }
            case 62: {
                if (!this.dsc.getDrawHotspots()) break;
                this.dsc.setDrawHotspots(false);
            }
        }
        return true;
    }

    public boolean keyTyped(char character) {
        switch (character) {
            case '\u0083': {
                EngineLogger.setDebugLevel(0);
                break;
            }
            case '\u0084': {
                EngineLogger.setDebugLevel(1);
                break;
            }
            case '1': {
                break;
            }
            case 'f': {
                break;
            }
            case 'i': {
                this.dsc.tap(SceneScreen.ActionButton.INVENTORY, 1);
                break;
            }
            case '\n': 
            case '\r': 
            case 'q': {
                this.dsc.getUI().setInputMode(UI.InputMode.GAMEPAD);
                if (this.sceneControllerHandler.clickOnUI()) break;
                this.dsc.tap(SceneScreen.ActionButton.LOOKAT, 1);
                break;
            }
            case 'e': {
                this.dsc.getUI().setInputMode(UI.InputMode.GAMEPAD);
                if (this.sceneControllerHandler.clickOnUI()) break;
                this.dsc.tap(SceneScreen.ActionButton.ACTION, 1);
                break;
            }
            case 's': {
                if (!EngineLogger.debugMode()) break;
                try {
                    this.dsc.getUI().getWorld().saveGameState();
                }
                catch (IOException e) {
                    EngineLogger.error(e.getMessage());
                }
                break;
            }
            case 'l': {
                if (!EngineLogger.debugMode()) break;
                try {
                    this.dsc.getUI().getWorld().loadGameState();
                }
                catch (IOException e) {
                    EngineLogger.error(e.getMessage());
                }
                break;
            }
            case 't': {
                if (!EngineLogger.debugMode()) break;
                this.dsc.getUI().getTesterBot().setEnabled(!this.dsc.getUI().getTesterBot().isEnabled());
                this.dsc.updateUI();
                break;
            }
            case '.': {
                if (!EngineLogger.debugMode()) break;
                this.dsc.getUI().getRecorder().setRecording(!this.dsc.getUI().getRecorder().isRecording());
                this.dsc.updateUI();
                break;
            }
            case ',': {
                if (!EngineLogger.debugMode()) break;
                if (this.dsc.getUI().getRecorder().isPlaying()) {
                    this.dsc.getUI().getRecorder().setPlaying(false);
                } else {
                    this.dsc.getUI().getRecorder().load();
                    this.dsc.getUI().getRecorder().setPlaying(true);
                }
                this.dsc.updateUI();
                break;
            }
            case 'p': {
                if (this.dsc.getUI().getWorld().isPaused()) {
                    this.dsc.resume();
                    break;
                }
                this.dsc.pause();
                break;
            }
            case 'z': {
                this.sceneControllerHandler.focusNext(ScreenControllerHandler.PointerToNextType.LEFT);
                break;
            }
            case 'x': {
                this.sceneControllerHandler.focusNext(ScreenControllerHandler.PointerToNextType.RIGHT);
                break;
            }
            case ' ': {
                if (!this.dsc.isUiEnabled() || this.dsc.getUI().getWorld().hasDialogOptions()) break;
                this.dsc.setDrawHotspots(true);
            }
        }
        return false;
    }

    public boolean scrolled(float amountX, float amountY) {
        if (this.dsc.isUiEnabled() && !this.dsc.getUI().getWorld().hasDialogOptions() && this.dsc.getUI().getWorld().getInventory().isVisible()) {
            boolean fromDown;
            this.dsc.getUI().setInputMode(UI.InputMode.MOUSE);
            boolean bl = fromDown = this.dsc.getInventoryUI().getInventoryPos() == InventoryUI.InventoryPos.CENTER || this.dsc.getInventoryUI().getInventoryPos() == InventoryUI.InventoryPos.DOWN;
            if ((amountY > 0.0f && fromDown || amountY < 0.0f && !fromDown) && this.dsc.getInventoryUI().isVisible()) {
                this.dsc.getInventoryUI().hide();
            } else if ((amountY > 0.0f && !fromDown || amountY < 0.0f && fromDown) && !this.dsc.getInventoryUI().isVisible()) {
                if (this.dsc.getUIMode() == DefaultSceneScreen.UIModes.PIE && this.dsc.getPie().isVisible()) {
                    this.dsc.getPie().hide();
                }
                this.dsc.getInventoryUI().show();
            }
        }
        return true;
    }
}

