/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui.defaults;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.input.GestureDetector;
import com.bladecoder.engine.ui.SceneScreen;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.ui.defaults.DefaultSceneScreen;
import com.bladecoder.engine.util.EngineLogger;

public class SceneGestureListener
extends GestureDetector.GestureAdapter {
    private final DefaultSceneScreen dsc;

    public SceneGestureListener(DefaultSceneScreen dsc) {
        this.dsc = dsc;
    }

    public boolean touchDown(float x, float y, int pointer, int button) {
        return true;
    }

    public boolean tap(float x, float y, int count, int button) {
        EngineLogger.debug("Event TAP button: " + button + " count: " + count);
        if (Gdx.input.isPeripheralAvailable(Input.Peripheral.MultitouchScreen)) {
            this.dsc.getUI().setInputMode(UI.InputMode.TOUCHPANEL);
        } else {
            this.dsc.getUI().setInputMode(UI.InputMode.MOUSE);
        }
        SceneScreen.ActionButton actionButton = SceneGestureListener.mouseToAction(button);
        this.dsc.tap(actionButton, count);
        return true;
    }

    public boolean longPress(float x, float y) {
        EngineLogger.debug("Event LONG PRESS");
        if (this.dsc.isUiEnabled() && !this.dsc.getWorld().hasDialogOptions()) {
            this.dsc.setDrawHotspots(true);
        }
        return false;
    }

    public boolean pan(float x, float y, float deltaX, float deltaY) {
        return true;
    }

    public boolean panStop(float x, float y, int pointer, int button) {
        this.tap(x, y, 1, button);
        return true;
    }

    public static SceneScreen.ActionButton mouseToAction(int b) {
        if (b == 0) {
            return SceneScreen.ActionButton.LOOKAT;
        }
        if (b == 1) {
            return SceneScreen.ActionButton.ACTION;
        }
        if (b == 2) {
            return SceneScreen.ActionButton.INVENTORY;
        }
        return SceneScreen.ActionButton.NONE;
    }
}

