/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui.defaults;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.util.EngineLogger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ScreenControllerHandler {
    public static final float THUMBSTICKVELOCITY = 720.0f;
    private final Stage stage;
    private final UI ui;
    private final Viewport viewport;
    private int pressed = -1;

    public ScreenControllerHandler(UI ui, Stage stage, Viewport viewport) {
        this.stage = stage;
        this.ui = ui;
        this.viewport = viewport;
    }

    public void update(float delta) {
        this.updateAxis(delta);
        this.updateDPad(delta);
        this.updateButtons();
    }

    private void updateButtons() {
        for (Controller controller : Controllers.getControllers()) {
            for (int buttonCode = controller.getMinButtonIndex(); buttonCode <= controller.getMaxButtonIndex(); ++buttonCode) {
                boolean p = controller.getButton(buttonCode);
                if (p) {
                    if (this.pressed != -1 && buttonCode != this.pressed) {
                        this.buttonUp(controller, this.pressed);
                    }
                    this.pressed = buttonCode;
                    continue;
                }
                if (buttonCode != this.pressed) continue;
                this.buttonUp(controller, this.pressed);
                this.pressed = -1;
            }
        }
    }

    protected boolean buttonUp(Controller controller, int buttonCode) {
        EngineLogger.debug(buttonCode + " gamepad button up.");
        this.ui.setInputMode(UI.InputMode.GAMEPAD);
        if (buttonCode == controller.getMapping().buttonStart) {
            if (this.ui.getCurrentScreen() != this.ui.getScreen(UI.Screens.MENU_SCREEN)) {
                this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
            }
            return true;
        }
        if (buttonCode == controller.getMapping().buttonA || buttonCode == controller.getMapping().buttonB) {
            int x = Gdx.input.getX();
            int y = Gdx.input.getY();
            int pointer = buttonCode == controller.getMapping().buttonA ? 11 : 12;
            this.stage.touchDown(x, y, pointer, 0);
            boolean handled = this.stage.touchUp(x, y, pointer, 0);
            return handled;
        }
        if (buttonCode == controller.getMapping().buttonR1 || buttonCode == controller.getMapping().buttonR2) {
            this.focusNext(PointerToNextType.RIGHT);
            return true;
        }
        if (buttonCode == controller.getMapping().buttonL1 || buttonCode == controller.getMapping().buttonL2) {
            this.focusNext(PointerToNextType.LEFT);
            return true;
        }
        return false;
    }

    public boolean clickOnUI() {
        int x = Gdx.input.getX();
        int y = Gdx.input.getY();
        int pointer = 11;
        this.stage.touchDown(x, y, pointer, 0);
        return this.stage.touchUp(x, y, pointer, 0);
    }

    public void focusNext(PointerToNextType type) {
        ArrayList<Vector2> positions = new ArrayList<Vector2>();
        Array actors = this.stage.getActors();
        Button hit = this.getButtonUnderCursor(this.stage);
        if (hit != null) {
            hit.getClickListener().exit(null, 0.0f, 0.0f, -1, null);
        }
        this.addActors((Array<Actor>)actors, positions, (Actor)hit);
        this.setNextCursorPosition(positions, type);
        hit = this.getButtonUnderCursor(this.stage);
        if (hit != null) {
            hit.getClickListener().enter(null, 0.0f, 0.0f, -1, null);
        }
    }

    protected Button getButtonUnderCursor(Stage stage) {
        Actor hit;
        Vector2 inputPos = new Vector2((float)Gdx.input.getX(), (float)Gdx.input.getY());
        stage.screenToStageCoordinates(inputPos);
        if (hit != null) {
            for (hit = stage.hit(inputPos.x, inputPos.y, true); !(hit instanceof Button) && hit != null; hit = hit.getParent()) {
            }
            EngineLogger.debug("HIT!!: " + hit);
        }
        return (Button)hit;
    }

    protected void addActors(Array<Actor> actors, List<Vector2> positions, Actor hit) {
        for (Actor a : actors) {
            if (a == hit || !a.isVisible()) continue;
            if (a instanceof Button) {
                Vector2 pos = new Vector2();
                a.localToScreenCoordinates(pos);
                pos.x += a.getWidth() / 2.0f;
                pos.y -= a.getHeight() / 2.0f;
                positions.add(pos);
                EngineLogger.debug("ADD: " + a + " pos: " + pos);
                continue;
            }
            if (!(a instanceof Group)) continue;
            this.addActors((Array<Actor>)((Group)a).getChildren(), positions, hit);
        }
    }

    public static void cursorToActor(Actor target) {
        Vector2 pos = new Vector2(target.getWidth() / 2.0f, target.getHeight() / 2.0f);
        target.localToScreenCoordinates(pos);
        Gdx.input.setCursorPosition((int)pos.x, (int)pos.y);
        target.getStage().mouseMoved(Gdx.input.getX(), Gdx.input.getY());
    }

    protected void setNextCursorPosition(List<Vector2> positions, PointerToNextType type) {
        if (positions.isEmpty()) {
            return;
        }
        if (type == PointerToNextType.RIGHT) {
            positions.sort(new Comparator<Vector2>(){

                @Override
                public int compare(Vector2 o1, Vector2 o2) {
                    int val = (int)(o1.x - o2.x);
                    if (val == 0) {
                        val = (int)(o1.y - o2.y);
                    }
                    return val;
                }
            });
        } else {
            positions.sort(new Comparator<Vector2>(){

                @Override
                public int compare(Vector2 o1, Vector2 o2) {
                    int val = (int)(o2.x - o1.x);
                    if (val == 0) {
                        val = (int)(o2.y - o1.y);
                    }
                    return val;
                }
            });
        }
        int idx = 0;
        Vector2 mPos = new Vector2((float)Gdx.input.getX(), (float)Gdx.input.getY());
        for (int i = 0; i < positions.size(); ++i) {
            Vector2 actPos = positions.get(i);
            if (type == PointerToNextType.RIGHT ? (int)actPos.x < (int)mPos.x || (int)actPos.x == (int)mPos.x && (int)actPos.y < (int)mPos.y : (int)actPos.x > (int)mPos.x || (int)actPos.x == (int)mPos.x && (int)actPos.y > (int)mPos.y) continue;
            idx = i;
            break;
        }
        EngineLogger.debug("Selected: " + positions.get(idx) + " IDX: " + idx);
        Gdx.input.setCursorPosition((int)positions.get((int)idx).x, (int)positions.get((int)idx).y);
    }

    private void updateAxis(int vx, int vy) {
        if (vx != 0 || vy != 0) {
            int x = Gdx.input.getX() + vx;
            int y = Gdx.input.getY() + vy;
            this.ui.setInputMode(UI.InputMode.GAMEPAD);
            Gdx.input.setCursorPosition(MathUtils.clamp((int)x, (int)this.viewport.getScreenX(), (int)(this.viewport.getScreenWidth() + this.viewport.getScreenX())), MathUtils.clamp((int)y, (int)this.viewport.getScreenY(), (int)(this.viewport.getScreenHeight() + this.viewport.getScreenY())));
            if (this.stage != null) {
                this.stage.mouseMoved(Gdx.input.getX(), Gdx.input.getY());
            }
        }
    }

    private float getVelocity(float delta) {
        return 720.0f * delta * (float)this.viewport.getScreenWidth() / 1080.0f;
    }

    private void updateAxis(float delta) {
        float v = this.getVelocity(delta);
        int vx = 0;
        int vy = 0;
        for (Controller controller : Controllers.getControllers()) {
            vx = (int)((float)vx + controller.getAxis(controller.getMapping().axisLeftX) * v);
            vy = (int)((float)vy + controller.getAxis(controller.getMapping().axisLeftY) * v);
            vx = (int)((float)vx + controller.getAxis(controller.getMapping().axisRightX) * v / 2.0f);
            vy = (int)((float)vy + controller.getAxis(controller.getMapping().axisRightY) * v / 2.0f);
        }
        this.updateAxis(vx, vy);
    }

    private void updateDPad(float delta) {
        float v = this.getVelocity(delta);
        int vx = 0;
        int vy = 0;
        for (Controller controller : Controllers.getControllers()) {
            if (controller.getButton(controller.getMapping().buttonDpadRight)) {
                vx = (int)((float)vx + v);
            } else if (controller.getButton(controller.getMapping().buttonDpadLeft)) {
                vx = (int)((float)vx - v);
            }
            if (controller.getButton(controller.getMapping().buttonDpadUp)) {
                vy = (int)((float)vy - v);
                continue;
            }
            if (!controller.getButton(controller.getMapping().buttonDpadDown)) continue;
            vy = (int)((float)vy + v);
        }
        if (Gdx.input.isKeyPressed(32) || Gdx.input.isKeyPressed(22)) {
            vx = (int)((float)vx + v);
        } else if (Gdx.input.isKeyPressed(29) || Gdx.input.isKeyPressed(21)) {
            vx = (int)((float)vx - v);
        }
        if (Gdx.input.isKeyPressed(51) || Gdx.input.isKeyPressed(19)) {
            vy = (int)((float)vy - v);
        } else if (Gdx.input.isKeyPressed(47) || Gdx.input.isKeyPressed(20)) {
            vy = (int)((float)vy + v);
        }
        this.updateAxis(vx, vy);
    }

    public static enum PointerToNextType {
        LEFT,
        RIGHT;

    }
}

