/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.util;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;

public class DPIUtils {
    public static final float BASE_DPI = 160.0f;
    public static final float DPI = 160.0f * DPIUtils.getLogicalDensity();
    public static final float TOUCH_MIN_SIZE = 48.0f * DPIUtils.getLogicalDensity();
    public static final float UI_SPACE = 8.0f * DPIUtils.getLogicalDensity();
    public static final float MARGIN_SIZE = 16.0f * DPIUtils.getLogicalDensity();
    public static final float BUTTON_SIZE = 56.0f * DPIUtils.getLogicalDensity();
    public static final float ICON_SIZE = 24.0f * DPIUtils.getLogicalDensity();
    public static final float SPACING = 8.0f * DPIUtils.getLogicalDensity();
    public static final float SCREEN_HEIGHT_DP = (float)Gdx.graphics.getHeight() / DPIUtils.getLogicalDensity();
    public static final float NORMAL_MULTIPLIER = 1.0f;
    public static final float LARGE_MULTIPLIER = 1.5f;
    public static final float XLARGE_MULTIPLIER = 2.0f;
    public static final float XXLARGE_MULTIPLIER = 2.5f;

    public static final float getLogicalDensity() {
        return Gdx.graphics.getDensity() / Gdx.graphics.getBackBufferScale();
    }

    public static float getPrefButtonSize() {
        return DPIUtils.getSizeMultiplier() * BUTTON_SIZE;
    }

    public static float getTouchMinSize() {
        return DPIUtils.getSizeMultiplier() * TOUCH_MIN_SIZE;
    }

    public static float getMarginSize() {
        return DPIUtils.getSizeMultiplier() * MARGIN_SIZE;
    }

    public static float getSpacing() {
        return DPIUtils.getSizeMultiplier() * SPACING;
    }

    public static float getSizeMultiplier() {
        int width = Gdx.graphics.isFullscreen() && Gdx.app.getType() == Application.ApplicationType.Desktop ? Gdx.graphics.getDisplayMode().width : Gdx.graphics.getWidth();
        float inches = DPIUtils.pixelsToInches(width);
        float s = inches / 6.0f;
        return Math.max(1.0f, s);
    }

    public static int dpToPixels(int dp) {
        return (int)((float)dp * DPIUtils.getLogicalDensity());
    }

    public static int pixelsToDP(int pixels) {
        return (int)((float)pixels / DPIUtils.getLogicalDensity());
    }

    public static float pixelsToInches(int pixels) {
        return (float)pixels / DPI;
    }

    public static float ptToPixels(float pts) {
        return pts * 72.0f / DPI;
    }
}

