/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.util;

import com.badlogic.gdx.Gdx;
import java.io.PrintWriter;
import java.io.StringWriter;

public class EngineLogger {
    private static String TAG = "ENGINE";
    private static int level = 1;
    private static final int MAX_BUFFER_SIZE = 524288;
    public static final int DEBUG0 = 0;
    public static final int DEBUG1 = 1;
    public static int debugLevel = 0;
    public static String lastError = null;
    public static Exception lastException = null;
    public static StringBuilder errorBuffer = new StringBuilder();

    public static void debug(String message) {
        Gdx.app.debug(TAG, message);
    }

    public static void error(String message) {
        if (message != null) {
            Gdx.app.error(TAG, message);
            lastError = message;
            lastException = null;
            if (errorBuffer.length() > 524288) {
                errorBuffer.setLength(0);
            }
            errorBuffer.append(message + "\n");
        }
    }

    public static void error(String message, Exception e) {
        EngineLogger.error(message);
        if (e != null) {
            Gdx.app.error(TAG, message, (Throwable)e);
            lastException = e;
            if (errorBuffer.length() > 524288) {
                errorBuffer.setLength(0);
            }
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            e.printStackTrace(printWriter);
            errorBuffer.append(((Object)result).toString());
        }
    }

    public static void toggle() {
        level = level == 3 ? 1 : 3;
        Gdx.app.setLogLevel(level);
    }

    public static boolean debugMode() {
        return level == 3;
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void setDebugLevel(int level) {
        debugLevel = level;
    }

    public static void setDebug() {
        level = 3;
        Gdx.app.setLogLevel(level);
    }
}

