/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.util;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import java.util.ArrayList;
import java.util.List;

public final class MultiFontBitmapFontData
extends FreeTypeFontGenerator.FreeTypeBitmapFontData {
    private final List<FreeTypeFontGenerator.FreeTypeBitmapFontData> fallBackBitmapFontData = new ArrayList<FreeTypeFontGenerator.FreeTypeBitmapFontData>();
    private final List<FreeTypeFontGenerator> fallbackFontGenerators = new ArrayList<FreeTypeFontGenerator>();
    private PixmapPacker packer;

    public void addFallBackFont(FileHandle fontFile, FreeTypeFontGenerator.FreeTypeFontParameter parameter) {
        FreeTypeFontGenerator.FreeTypeBitmapFontData fallbackData = new FreeTypeFontGenerator.FreeTypeBitmapFontData();
        fallbackData.regions = this.regions;
        parameter.packer = this.packer;
        FreeTypeFontGenerator fallbackGen = new FreeTypeFontGenerator(fontFile);
        this.fallbackFontGenerators.add(fallbackGen);
        this.fallBackBitmapFontData.add(fallbackGen.generateData(parameter, fallbackData));
    }

    public void createPacker(FreeTypeFontGenerator.FreeTypeFontParameter parameter) {
        int maxTextureSize;
        int size = maxTextureSize = 1024;
        PixmapPacker.GuillotineStrategy packStrategy = new PixmapPacker.GuillotineStrategy();
        PixmapPacker packer = new PixmapPacker(size, size, Pixmap.Format.RGBA8888, 1, false, (PixmapPacker.PackStrategy)packStrategy);
        packer.setTransparentColor(parameter.color);
        packer.getTransparentColor().a = 0.0f;
        if (parameter.borderWidth > 0.0f) {
            packer.setTransparentColor(parameter.borderColor);
            packer.getTransparentColor().a = 0.0f;
        }
        this.packer = packer;
        parameter.packer = packer;
    }

    public BitmapFont.Glyph getGlyph(char ch) {
        BitmapFont.Glyph glyph = super.getGlyph(ch);
        if (glyph == null && this.fallBackBitmapFontData != null) {
            for (FreeTypeFontGenerator.FreeTypeBitmapFontData data : this.fallBackBitmapFontData) {
                glyph = data.getGlyph(ch);
                if (glyph == null) continue;
                return glyph;
            }
        }
        return glyph;
    }

    public void dispose() {
        super.dispose();
        this.packer.dispose();
        for (FreeTypeFontGenerator.FreeTypeBitmapFontData data : this.fallBackBitmapFontData) {
            data.dispose();
        }
        for (FreeTypeFontGenerator gen : this.fallbackFontGenerators) {
            gen.dispose();
        }
    }
}

