/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.util;

import com.badlogic.gdx.math.GeometryUtils;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Vector2;
import com.bladecoder.engine.util.EngineLogger;

public class PolygonUtils {
    private static final Vector2 tmp = new Vector2();
    private static final Vector2 tmp2 = new Vector2();
    private static float TOLERANCE_IS_POINT_INSIDE = 3.0f;
    private static float TOLERANCE_LINE_SEGMENTS_CROSS = 0.01f;

    public static void addPoint(Polygon poly, float x, float y, int index) {
        float[] verts = poly.getVertices();
        int length = verts.length;
        float[] destination = new float[length + 2];
        System.arraycopy(verts, 0, destination, 0, index);
        destination[index] = x -= poly.getX();
        destination[index + 1] = y -= poly.getY();
        System.arraycopy(verts, index, destination, index + 2, length - index);
        poly.setVertices(destination);
    }

    public static void deletePoint(Polygon poly, int index) {
        float[] verts = poly.getVertices();
        if (verts.length < 8) {
            return;
        }
        int length = verts.length;
        float[] destination = new float[length - 2];
        System.arraycopy(verts, 0, destination, 0, index);
        System.arraycopy(verts, index + 2, destination, index, length - index - 2);
        poly.setVertices(destination);
    }

    public static boolean deletePoint(Polygon poly, float x, float y, float tolerance) {
        float[] verts = poly.getTransformedVertices();
        for (int i = 0; i < verts.length; i += 2) {
            if (!(Vector2.dst((float)x, (float)y, (float)verts[i], (float)verts[i + 1]) < tolerance)) continue;
            PolygonUtils.deletePoint(poly, i);
            return true;
        }
        return false;
    }

    public static void addClampedPoint(Polygon poly, float x, float y) {
        int i = PolygonUtils.getClampedPoint(poly, x, y, tmp2);
        PolygonUtils.addPoint(poly, PolygonUtils.tmp2.x, PolygonUtils.tmp2.y, i + 2);
    }

    public static int getClampedPoint(Polygon poly, float x, float y, Vector2 dest) {
        float dTmp;
        int i;
        float[] verts = poly.getTransformedVertices();
        Intersector.nearestSegmentPoint((float)verts[0], (float)verts[1], (float)verts[2], (float)verts[3], (float)x, (float)y, (Vector2)dest);
        int nearest = 0;
        float d = Vector2.dst((float)x, (float)y, (float)dest.x, (float)dest.y);
        for (i = 2; i < verts.length; i += 2) {
            Intersector.nearestSegmentPoint((float)verts[i], (float)verts[i + 1], (float)verts[(i + 2) % verts.length], (float)verts[(i + 3) % verts.length], (float)x, (float)y, (Vector2)tmp);
            dTmp = Vector2.dst((float)x, (float)y, (float)PolygonUtils.tmp.x, (float)PolygonUtils.tmp.y);
            if (!(dTmp < d)) continue;
            d = dTmp;
            nearest = i;
            dest.set(tmp);
        }
        if (!PolygonUtils.isPointInside(poly, dest.x, dest.y, true)) {
            EngineLogger.debug("> PolygonalPathFinder: CLAMPED FAILED!!");
            tmp.set(verts[0], verts[1]);
            d = Vector2.dst((float)x, (float)y, (float)PolygonUtils.tmp.x, (float)PolygonUtils.tmp.y);
            nearest = 0;
            dest.set(tmp);
            for (i = 2; i < verts.length; i += 2) {
                tmp.set(verts[i], verts[i + 1]);
                dTmp = Vector2.dst((float)x, (float)y, (float)PolygonUtils.tmp.x, (float)PolygonUtils.tmp.y);
                if (!(dTmp < d)) continue;
                d = dTmp;
                nearest = i;
                dest.set(tmp);
            }
        }
        return nearest;
    }

    public static boolean addClampPointIfTolerance(Polygon poly, float x, float y, float tolerance) {
        boolean added = false;
        int i = PolygonUtils.getClampedPoint(poly, x, y, tmp2);
        if (tmp2.dst(x, y) < tolerance) {
            added = true;
            PolygonUtils.addPoint(poly, PolygonUtils.tmp2.x, PolygonUtils.tmp2.y, i + 2);
        }
        return added;
    }

    public static boolean isVertexConcave(Polygon poly, int index) {
        float[] verts = poly.getTransformedVertices();
        float currentX = verts[index];
        float currentY = verts[index + 1];
        float nextX = verts[(index + 2) % verts.length];
        float nextY = verts[(index + 3) % verts.length];
        float previousX = verts[index == 0 ? verts.length - 2 : index - 2];
        float previousY = verts[index == 0 ? verts.length - 1 : index - 1];
        float leftX = currentX - previousX;
        float leftY = currentY - previousY;
        float rightX = nextX - currentX;
        float rightY = nextY - currentY;
        float cross = leftX * rightY - leftY * rightX;
        return cross < 0.0f;
    }

    public static boolean isPointInside(Polygon polygon, float x, float y, boolean toleranceOnOutside) {
        float[] verts = polygon.getTransformedVertices();
        boolean inside = false;
        float oldX = verts[verts.length - 2];
        float oldY = verts[verts.length - 1];
        float oldSqDist = Vector2.dst2((float)oldX, (float)oldY, (float)x, (float)y);
        for (int i = 0; i < verts.length; i += 2) {
            float newX = verts[i];
            float newY = verts[i + 1];
            float newSqDist = Vector2.dst2((float)newX, (float)newY, (float)x, (float)y);
            if ((double)(oldSqDist + newSqDist) + 2.0 * Math.sqrt(oldSqDist * newSqDist) - (double)Vector2.dst2((float)newX, (float)newY, (float)oldX, (float)oldY) < (double)TOLERANCE_IS_POINT_INSIDE) {
                return toleranceOnOutside;
            }
            float leftX = newX;
            float leftY = newY;
            float rightX = oldX;
            float rightY = oldY;
            if (newX > oldX) {
                leftX = oldX;
                leftY = oldY;
                rightX = newX;
                rightY = newY;
            }
            if (leftX < x && x <= rightX && (y - leftY) * (rightX - leftX) < (rightY - leftY) * (x - leftX)) {
                inside = !inside;
            }
            oldX = newX;
            oldY = newY;
            oldSqDist = newSqDist;
        }
        return inside;
    }

    public static boolean inLineOfSight(Vector2 p1, Vector2 p2, Polygon polygon, boolean obstacle) {
        tmp.set(p1);
        tmp2.set(p2);
        float[] verts = polygon.getTransformedVertices();
        for (int i = 0; i < verts.length; i += 2) {
            if (!PolygonUtils.lineSegmentsCross(PolygonUtils.tmp.x, PolygonUtils.tmp.y, PolygonUtils.tmp2.x, PolygonUtils.tmp2.y, verts[i], verts[i + 1], verts[(i + 2) % verts.length], verts[(i + 3) % verts.length])) continue;
            return false;
        }
        tmp.add(tmp2);
        PolygonUtils.tmp.x /= 2.0f;
        PolygonUtils.tmp.y /= 2.0f;
        boolean result = PolygonUtils.isPointInside(polygon, PolygonUtils.tmp.x, PolygonUtils.tmp.y, !obstacle);
        return obstacle ? !result : result;
    }

    public static boolean lineSegmentsCross(float ax, float ay, float bx, float by, float cx, float cy, float dx, float dy) {
        float denominator = (bx - ax) * (dy - cy) - (by - ay) * (dx - cx);
        if (denominator < TOLERANCE_LINE_SEGMENTS_CROSS && denominator > -TOLERANCE_LINE_SEGMENTS_CROSS) {
            return false;
        }
        float numerator1 = (ay - cy) * (dx - cx) - (ax - cx) * (dy - cy);
        float numerator2 = (ay - cy) * (bx - ax) - (ax - cx) * (by - ay);
        if (numerator1 < TOLERANCE_LINE_SEGMENTS_CROSS && numerator1 > -TOLERANCE_LINE_SEGMENTS_CROSS || numerator2 < TOLERANCE_LINE_SEGMENTS_CROSS && numerator2 > -TOLERANCE_LINE_SEGMENTS_CROSS) {
            return false;
        }
        float r = numerator1 / denominator;
        float s = numerator2 / denominator;
        return r > TOLERANCE_LINE_SEGMENTS_CROSS && r < 1.0f - TOLERANCE_LINE_SEGMENTS_CROSS && s > TOLERANCE_LINE_SEGMENTS_CROSS && s < 1.0f - TOLERANCE_LINE_SEGMENTS_CROSS;
    }

    public static void ensureClockWise(float[] polygon, int offset, int count) {
        if (GeometryUtils.isClockwise((float[])polygon, (int)offset, (int)count)) {
            return;
        }
        int lastX = offset + count - 2;
        int n = offset + count / 2;
        for (int i = offset; i < n; i += 2) {
            int other = lastX - i;
            float x = polygon[i];
            float y = polygon[i + 1];
            polygon[i] = polygon[other];
            polygon[i + 1] = polygon[other + 1];
            polygon[other] = x;
            polygon[other + 1] = y;
        }
    }
}

