/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.util;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.Verb;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.DPIUtils;

public class UIUtils {
    private static final Vector3 unprojectTmp = new Vector3();
    private static final Vector2 unproject2Tmp = new Vector2();

    public static void showUIText(Stage stage, Skin skin, World w, Text t) {
        String style = t.style == null ? "ui-text" : t.style;
        Label msg = new Label((CharSequence)t.str, skin, style);
        msg.setWrap(true);
        msg.setAlignment(1, 1);
        if (t.color != null) {
            msg.setColor(t.color);
        }
        msg.setSize(msg.getWidth() + DPIUtils.getMarginSize() * 2.0f, msg.getHeight() + DPIUtils.getMarginSize() * 2.0f);
        stage.addActor((Actor)msg);
        unprojectTmp.set(t.x, t.y, 0.0f);
        w.getSceneCamera().scene2screen(stage.getViewport(), unprojectTmp);
        float posx = t.x == -1.0f ? ((float)stage.getViewport().getScreenWidth() - msg.getWidth()) / 2.0f : (t.x == -2.0f ? DPIUtils.getMarginSize() : UIUtils.unprojectTmp.x);
        float posy = t.y == -1.0f ? ((float)stage.getViewport().getScreenHeight() - msg.getHeight()) / 2.0f : (t.y == -2.0f ? (float)stage.getViewport().getScreenHeight() - msg.getHeight() - DPIUtils.getMarginSize() * 3.0f : UIUtils.unprojectTmp.y);
        msg.setPosition(posx, posy);
        msg.getColor().a = 0.0f;
        msg.addAction((Action)Actions.sequence((Action)Actions.fadeIn((float)0.4f, (Interpolation)Interpolation.fade), (Action)Actions.delay((float)t.time, (Action)Actions.sequence((Action)Actions.fadeOut((float)0.4f, (Interpolation)Interpolation.fade), (Action)Actions.removeActor()))));
    }

    public static float calcLeaveArrowRotation(Viewport viewport, InteractiveActor actor) {
        Verb verb = actor.getVerb("leave");
        if (verb == null || verb.getIcon() == null) {
            actor.getBBox().getBoundingRectangle().getCenter(unproject2Tmp);
            if (UIUtils.unproject2Tmp.x < viewport.getWorldWidth() / 3.0f) {
                return 180.0f;
            }
            if (UIUtils.unproject2Tmp.x > viewport.getWorldWidth() / 3.0f * 2.0f) {
                return 0.0f;
            }
            if (UIUtils.unproject2Tmp.y < viewport.getWorldHeight() / 5.0f) {
                return -90.0f;
            }
            return 90.0f;
        }
        String dir = verb.getIcon();
        if (dir.equals("left")) {
            return 180.0f;
        }
        if (dir.equals("right")) {
            return 0.0f;
        }
        if (dir.equals("down")) {
            return -90.0f;
        }
        return 90.0f;
    }
}

