/*
 * Decompiled with CFR 0.152.
 */
package blade.cache;

import blade.cache.Cache;
import blade.cache.CacheObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    protected Map<K, CacheObject<K, V>> _mCache;
    protected Map<K, Map<?, CacheObject<K, V>>> _hCache;
    protected final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.cacheLock.readLock();
    protected final Lock writeLock = this.cacheLock.writeLock();
    protected int cacheSize;
    protected long defaultExpire;
    protected boolean existCustomExpire;

    protected abstract int eliminateCache();

    public AbstractCache(int cacheSize) {
        this.cacheSize = cacheSize;
        this._mCache = Collections.synchronizedMap(new HashMap());
        this._hCache = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void set(K key, V obj) {
        this.set(key, obj, this.defaultExpire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(K key, V value, long expire) {
        this.writeLock.lock();
        try {
            CacheObject<K, V> co = new CacheObject<K, V>(key, value, expire);
            if (expire != 0L) {
                this.existCustomExpire = true;
            }
            if (this.isFull()) {
                this.eliminate();
            }
            this._mCache.put(key, co);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public <F> void hset(K key, F field, V obj) {
        this.hset(key, field, obj, this.defaultExpire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <F> void hset(K key, F field, V value, long expire) {
        this.writeLock.lock();
        try {
            Map<?, CacheObject<F, CacheObject<K, V>>> coMap;
            CacheObject<K, V> co = new CacheObject<K, V>(key, value, expire);
            if (expire != 0L) {
                this.existCustomExpire = true;
            }
            if (this.isFull()) {
                this.eliminate();
            }
            if (null == (coMap = this._hCache.get(key))) {
                coMap = new HashMap();
            }
            coMap.put(field, co);
            this._hCache.put(key, coMap);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.readLock.lock();
        try {
            CacheObject<K, V> co = this._mCache.get(key);
            if (co == null) {
                V v = null;
                return v;
            }
            if (co.isExpired()) {
                this._mCache.remove(key);
                V v = null;
                return v;
            }
            V v = co.getValue();
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <F> V hget(K key, F field) {
        this.readLock.lock();
        try {
            Map<?, CacheObject<K, V>> coMap = this._hCache.get(key);
            if (null == coMap) {
                V v = null;
                return v;
            }
            CacheObject<K, V> co = coMap.get(field);
            if (null == co) {
                V v = null;
                return v;
            }
            if (co.isExpired()) {
                coMap.remove(field);
                V v = null;
                return v;
            }
            V v = co.getValue();
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void del(K key) {
        this.writeLock.lock();
        try {
            this._mCache.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void hdel(K key) {
        this.writeLock.lock();
        try {
            this._hCache.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <F> void del(K key, F feild) {
        this.writeLock.lock();
        try {
            Map<?, CacheObject<K, V>> coMap = this._hCache.get(key);
            if (null != coMap) {
                coMap.remove(feild);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<K> keys() {
        return this._mCache.keySet();
    }

    @Override
    public <F> Set<F> flieds(K key) {
        Map<?, CacheObject<K, V>> coMap = this._hCache.get(key);
        if (null == coMap) {
            return null;
        }
        return coMap.keySet();
    }

    public int elementsInCache() {
        return this._mCache.size() + this._hCache.size();
    }

    @Override
    public int size() {
        return this._mCache.size() + this._hCache.size();
    }

    protected boolean isNeedClearExpiredObject() {
        return this.defaultExpire > 0L || this.existCustomExpire;
    }

    @Override
    public final int eliminate() {
        this.writeLock.lock();
        try {
            int n = this.eliminateCache();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean isFull() {
        if (this.cacheSize == 0) {
            return false;
        }
        return this._mCache.size() + this._hCache.size() >= this.cacheSize;
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this._mCache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Cache<K, V> cacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    @Override
    public Cache<K, V> expire(long expire) {
        this.defaultExpire = expire;
        return this;
    }
}

