/*
 * Decompiled with CFR 0.152.
 */
package blade.cache;

import blade.cache.Cache;
import blade.cache.CacheException;
import blade.cache.impl.FIFOCache;
import blade.cache.impl.LFUCache;
import blade.cache.impl.LRUCache;
import blade.kit.TaskKit;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CacheManager {
    private static final CacheManager _instance = new CacheManager();
    private static final String CACHE_SUFFIX = "blade_cache_ID_";
    private Map<String, Cache> _cacheMap = new HashMap<String, Cache>();
    private int _cacheSize = 100;
    private static final int DEFAULT_CLEAN_TIME = 3600;
    private ScheduledFuture scheduledFuture = TaskKit.scheduleAtFixedRate((Runnable)new Runnable(){

        @Override
        public void run() {
            CacheManager.this.removeAll();
        }
    }, (long)3600L, (long)3600L, (TimeUnit)TimeUnit.SECONDS);
    private static Object _mlock = new Object();

    public static CacheManager me() {
        return _instance;
    }

    public void setCleanInterval(long time) {
        this.scheduledFuture.cancel(true);
        this.scheduledFuture = TaskKit.scheduleAtFixedRate((Runnable)new Runnable(){

            @Override
            public void run() {
                CacheManager.this.removeAll();
            }
        }, (long)time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String cacheId) {
        if (cacheId == null) {
            throw new NullPointerException("cacheId is null");
        }
        Object object = _mlock;
        synchronized (object) {
            return this._cacheMap.get(cacheId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> newLRUCache() {
        Object object = _mlock;
        synchronized (object) {
            String cacheId = CACHE_SUFFIX + System.currentTimeMillis();
            return this.newLRUCache(cacheId, this._cacheSize);
        }
    }

    public <K, V> Cache<K, V> newLRUCache(String cacheId) {
        if (cacheId == null) {
            throw new NullPointerException("cacheId is null");
        }
        return this.newLRUCache(cacheId, this._cacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> newLRUCache(int cacheSize) {
        Object object = _mlock;
        synchronized (object) {
            String cacheId = CACHE_SUFFIX + System.currentTimeMillis();
            return this.newLRUCache(cacheId, cacheSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> newLRUCache(String cacheId, int cacheSize) {
        Object object = _mlock;
        synchronized (object) {
            LRUCache cache = new LRUCache(cacheSize);
            this._cacheMap.put(cacheId, cache);
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> newLFUCache() {
        Object object = _mlock;
        synchronized (object) {
            String cacheId = CACHE_SUFFIX + System.currentTimeMillis();
            return this.newLFUCache(cacheId, this._cacheSize);
        }
    }

    public <K, V> Cache<K, V> newLFUCache(String cacheId) {
        if (cacheId == null) {
            throw new NullPointerException("cacheId is null");
        }
        return this.newLFUCache(cacheId, this._cacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> newLFUCache(int cacheSize) {
        Object object = _mlock;
        synchronized (object) {
            String cacheId = CACHE_SUFFIX + System.currentTimeMillis();
            return this.newLFUCache(cacheId, cacheSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> newLFUCache(String cacheId, int cacheSize) {
        Object object = _mlock;
        synchronized (object) {
            LFUCache cache = new LFUCache(cacheSize);
            this._cacheMap.put(cacheId, cache);
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> newFIFOCache() {
        Object object = _mlock;
        synchronized (object) {
            String cacheId = CACHE_SUFFIX + System.currentTimeMillis();
            return this.newFIFOCache(cacheId, this._cacheSize);
        }
    }

    public <K, V> Cache<K, V> newFIFOCache(String cacheId) {
        if (cacheId == null) {
            throw new NullPointerException("cacheId is null");
        }
        return this.newLFUCache(cacheId, this._cacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> newFIFOCache(int cacheSize) {
        Object object = _mlock;
        synchronized (object) {
            String cacheId = CACHE_SUFFIX + System.currentTimeMillis();
            return this.newFIFOCache(cacheId, cacheSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> newFIFOCache(String cacheId, int cacheSize) {
        Object object = _mlock;
        synchronized (object) {
            FIFOCache cache = new FIFOCache(cacheSize);
            this._cacheMap.put(cacheId, cache);
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCacheIds() {
        Object object = _mlock;
        synchronized (object) {
            if (null != this._cacheMap && this._cacheMap.size() > 0) {
                return this._cacheMap.keySet();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(String cacheId) throws CacheException {
        if (cacheId == null) {
            throw new NullPointerException("cacheId is null");
        }
        Object object = _mlock;
        synchronized (object) {
            this._cacheMap.remove(cacheId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void removeAll() {
        Object object = _mlock;
        synchronized (object) {
            if (null != this._cacheMap && this._cacheMap.size() > 0) {
                Set<String> keys = this._cacheMap.keySet();
                for (String key : keys) {
                    Cache cache = this._cacheMap.get(key);
                    if (null == cache) continue;
                    cache.clear();
                }
                this._cacheMap.clear();
            }
        }
    }

    public void destroy() throws InterruptedException, ExecutionException {
        this.removeAll();
        this.scheduledFuture.cancel(true);
    }
}

