/*
 * Decompiled with CFR 0.152.
 */
package blade.cache;

public class CacheObject<K, V> {
    private K key;
    private V value;
    private long expires;
    private long lastAccess;
    private long accessCount;
    private CacheObject<K, V> previous;
    private CacheObject<K, V> next;

    public CacheObject(K k, V v, long expires) {
        this.key = k;
        this.value = v;
        this.expires = expires;
    }

    public CacheObject() {
    }

    public boolean isExpired() {
        if (this.expires == 0L) {
            return false;
        }
        return this.lastAccess + this.expires < System.currentTimeMillis();
    }

    public V getValue() {
        this.lastAccess = System.currentTimeMillis();
        ++this.accessCount;
        return this.value;
    }

    public K getKey() {
        return this.key;
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public long getAccessCount() {
        return this.accessCount;
    }

    public void setAccessCount(long accessCount) {
        this.accessCount = accessCount;
    }

    public CacheObject<K, V> getPrevious() {
        return this.previous;
    }

    public void setPrevious(CacheObject<K, V> previous) {
        this.previous = previous;
    }

    public CacheObject<K, V> getNext() {
        return this.next;
    }

    public void setNext(CacheObject<K, V> next) {
        this.next = next;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public void setValue(V value) {
        this.value = value;
    }
}

