package blade.plugin.sql2o;

import javax.sql.DataSource;

import blade.kit.StringKit;
import blade.log.Logger;
import blade.plugin.Plugin;
import blade.plugin.sql2o.connection.ConnectionManager;

/**
 * sql2o数据库插件
 * 
 * @author	<a href="mailto:biezhi.me@gmail.com" target="_blank">biezhi</a>
 * @since	1.0
 */
public class Sql2oPlugin implements Plugin {

	private static final Logger LOGGER = Logger.getLogger(Sql2oPlugin.class);
	
	private static DBConfig dbConfig;
	
	/**
	 * 设置数据库配置
	 * 
	 * @param url
	 * @param driver
	 * @param user
	 * @param pass
	 */
	public void config(String url, String driver, String user, String pass){
		
		if(StringKit.isNotEmpty(url) && StringKit.isNotEmpty(driver)
				&& StringKit.isNotEmpty(user) && StringKit.isNotEmpty(pass)){
		
			dbConfig = new DBConfig(driver, url,  user, pass);
		}
	}
	
	public static DBConfig getDbConfig(){
		return dbConfig;
	}
	
	@Override
	public void run() {
		DataSource dataSource = ConnectionManager.getDataSource();
		if(null != dataSource){
			Model.sql2o(dataSource);
			LOGGER.debug("数据库插件配置成功...");
		} else {
			LOGGER.error("数据库插件配置失败");
		}
	}

}
