/*
 * Decompiled with CFR 0.152.
 */
package com.blockchyp.client.crypto;

import java.security.Key;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang.StringUtils;

public final class CryptoUtils {
    public static final String HEADER_NONCE = "Nonce";
    public static final String HEADER_TIMESTAMP = "Timestamp";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String AUTH_SCHEME_DUAL = "Dual";
    public static final int AES_KEY_SIZE_IN_BYTES = 16;
    public static final int NONCE_SIZE_IN_BYTES = 32;
    private static CryptoUtils instance;
    private static Random rand;

    private CryptoUtils() {
        if (rand == null) {
            try {
                rand = new SecureRandom();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static CryptoUtils getInstance() {
        if (instance == null) {
            instance = new CryptoUtils();
        }
        return instance;
    }

    public String computeSHA256(String hex) {
        try {
            return DigestUtils.sha256Hex((byte[])Hex.decodeHex((String)hex));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> generateApiHeaders(String apiKey, String bearerToken, String signingKey) {
        HashMap<String, String> results = new HashMap<String, String>();
        Base32 base32 = new Base32();
        String nonce = StringUtils.remove((String)base32.encodeAsString(this.randomBytes(32)), (String)"=");
        String ts = this.generateTimestamp();
        String toSign = apiKey + bearerToken + ts + nonce;
        results.put(HEADER_NONCE, nonce);
        results.put(HEADER_TIMESTAMP, ts);
        try {
            Mac mac = HmacUtils.getInitializedMac((HmacAlgorithms)HmacAlgorithms.HMAC_SHA_256, (byte[])Hex.decodeHex((String)signingKey));
            String hmac = Hex.encodeHexString((byte[])mac.doFinal(toSign.getBytes()));
            String authHeader = "Dual " + bearerToken + ":" + apiKey + ":" + hmac;
            results.put(HEADER_AUTHORIZATION, authHeader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return results;
    }

    public String generateTimestamp() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return fmt.format(new Date());
    }

    public String decrypt(String cipherText, byte[] key) throws Exception {
        String[] tokens = StringUtils.split((String)cipherText, (String)"|");
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        byte[] iv = Hex.decodeHex((String)tokens[0]);
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)secretKey, paramSpec);
        return new String(cipher.doFinal(Hex.decodeHex((String)tokens[1])));
    }

    public String encrypt(String plainText, byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        byte[] iv = new byte[16];
        new Random().nextBytes(iv);
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)secretKey, paramSpec);
        return Hex.encodeHexString((byte[])iv) + "|" + Hex.encodeHexString((byte[])cipher.doFinal(plainText.getBytes()));
    }

    public byte[] randomBytes(int len) {
        byte[] results = new byte[len];
        byte[] buf = new byte[len * 2];
        int offset = rand.nextInt(len);
        rand.nextBytes(buf);
        System.arraycopy(buf, offset, results, 0, len);
        return results;
    }
}

