/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.automate.model;

import com.browserstack.automate.AutomateClient;
import com.browserstack.automate.exception.AutomateException;
import com.browserstack.automate.model.Build;
import com.browserstack.automate.model.BuildNode;
import com.browserstack.client.BrowserStackClient;
import com.browserstack.client.model.BrowserStackObject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Project
extends BrowserStackObject {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="updated_at")
    private String updatedAt;
    @JsonProperty(value="group_id")
    private int groupId;
    @JsonProperty(value="created_at")
    private String createdAt;
    @JsonProperty(value="id")
    private int id;
    @JsonProperty(value="user_id")
    private int userId;
    @JsonProperty(value="builds")
    private List<Build> builds;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Project() {
    }

    public Project(BrowserStackClient client, int projectId) {
        this.id = projectId;
        this.setClient(client);
    }

    public final boolean delete() throws AutomateException {
        return ((AutomateClient)this.getClient()).deleteProject(this.getId());
    }

    @Override
    public <T> T setClient(BrowserStackClient client) {
        if (this.builds != null) {
            for (Build build : this.builds) {
                if (build == null) continue;
                build.setClient(client);
            }
        }
        return super.setClient(client);
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    private void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="updated_at")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    private void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="group_id")
    public int getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    private void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    private void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="id")
    public int getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    private void setId(int id) {
        this.id = id;
    }

    @JsonProperty(value="user_id")
    public int getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_id")
    private void setUserId(int userId) {
        this.userId = userId;
    }

    @JsonProperty(value="builds")
    public List<Build> getBuilds() throws AutomateException {
        if (this.builds == null) {
            this.builds = ((AutomateClient)this.getClient()).getBuilds();
        }
        return this.builds;
    }

    @JsonProperty(value="builds")
    private void setBuilds(List<BuildNode> buildNodes) {
        ArrayList<Build> builds = new ArrayList<Build>();
        if (buildNodes != null) {
            for (BuildNode buildNode : buildNodes) {
                if (buildNode == null || buildNode.getBuild() == null) continue;
                builds.add(buildNode.getBuild());
            }
        }
        this.builds = builds;
    }

    @JsonAnyGetter
    protected Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    private void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

