/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.client;

import com.browserstack.automate.Automate;
import com.browserstack.automate.exception.BuildNotFound;
import com.browserstack.automate.exception.SessionNotFound;
import com.browserstack.automate.model.Build;
import com.browserstack.automate.model.BuildNode;
import com.browserstack.automate.model.Session;
import com.browserstack.automate.model.SessionNode;
import com.browserstack.client.BrowserStackClientInterface;
import com.browserstack.client.BrowserStackRequest;
import com.browserstack.client.exception.BrowserStackException;
import com.browserstack.client.exception.BrowserStackObjectNotFound;
import com.browserstack.client.model.BrowserListing;
import com.browserstack.client.util.BrowserStackCache;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class BrowserStackClient
implements BrowserStackClientInterface {
    private static final String BASE_URL = "https://www.browserstack.com";
    private static final String CACHE_KEY_PREFIX_BROWSERS = "browsers";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final ObjectParser OBJECT_PARSER = new ObjectParser(){

        public <T> T parseAndClose(InputStream inputStream, Charset charset, Class<T> aClass) throws IOException {
            return (T)JSON_MAPPER.readValue(inputStream, aClass);
        }

        public <T> T parseAndClose(Reader reader, Class<T> aClass) throws IOException {
            return (T)JSON_MAPPER.readValue(reader, aClass);
        }

        public Object parseAndClose(InputStream inputStream, Charset charset, Type type) throws IOException {
            throw new IOException("Unsupported operation");
        }

        public Object parseAndClose(Reader reader, Type type) throws IOException {
            throw new IOException("Unsupported operation");
        }
    };
    private static HttpTransport HTTP_TRANSPORT = new ApacheHttpTransport();
    protected final BrowserStackCache<String, Object> cacheMap = new BrowserStackCache();
    private HttpRequestFactory requestFactory = BrowserStackClient.newRequestFactory();
    private String baseUrl;
    private String username;
    private String accessKey;

    protected BrowserStackClient() {
    }

    public BrowserStackClient(String baseUrl, String username, String accessKey) {
        this();
        if (baseUrl == null) {
            throw new IllegalArgumentException("Invalid baseUrl");
        }
        if (username == null || username.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid username");
        }
        if (accessKey == null || accessKey.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid access key");
        }
        this.baseUrl = baseUrl;
        this.username = username.trim();
        this.accessKey = accessKey.trim();
    }

    static HttpRequestFactory newRequestFactory() {
        return HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest httpRequest) throws IOException {
                httpRequest.setParser(OBJECT_PARSER);
            }
        });
    }

    static HttpRequest newRequest(HttpRequestFactory requestFactory, Method method, GenericUrl url) throws BrowserStackException {
        HttpRequest request;
        if (method == null) {
            throw new IllegalArgumentException("Invalid method");
        }
        try {
            switch (method) {
                case GET: {
                    request = requestFactory.buildGetRequest(url);
                    break;
                }
                case POST: {
                    request = requestFactory.buildPostRequest(url, null);
                    break;
                }
                case PUT: {
                    request = requestFactory.buildPutRequest(url, null);
                    break;
                }
                case DELETE: {
                    request = requestFactory.buildDeleteRequest(url);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid method");
                }
            }
        }
        catch (IOException e) {
            throw new BrowserStackException(e);
        }
        return request;
    }

    @Override
    public void setProxy(String proxyHost, int proxyPort, String proxyUsername, String proxyPassword) {
        if (proxyHost == null || proxyUsername == null || proxyPassword == null) {
            return;
        }
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        AuthScope proxyAuthScope = new AuthScope(proxyHost, proxyPort);
        UsernamePasswordCredentials proxyAuthentication = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
        basicCredentialsProvider.setCredentials(proxyAuthScope, (Credentials)proxyAuthentication);
        HttpHost proxy = new HttpHost(proxyHost, proxyPort);
        CloseableHttpClient client = HttpClientBuilder.create().setProxy(proxy).setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider).build();
        ApacheHttpTransport transport = new ApacheHttpTransport((HttpClient)client);
        HTTP_TRANSPORT = transport;
        this.requestFactory = BrowserStackClient.newRequestFactory();
    }

    protected String getAccessKey() {
        return this.accessKey;
    }

    protected synchronized void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    private void checkAuthState() {
        if (this.accessKey == null && this.username == null) {
            throw new IllegalStateException("Missing API credentials");
        }
    }

    protected BrowserListing getBrowsersForProduct(Product product) throws BrowserStackException {
        return this.getBrowsersForProduct(product, true);
    }

    protected BrowserListing getBrowsersForProduct(Product product, boolean cache) throws BrowserStackException {
        BrowserListing browserListing;
        String productName = product.name().toLowerCase();
        String cacheKey = (CACHE_KEY_PREFIX_BROWSERS + productName).toLowerCase();
        if (cache && this.cacheMap.containsKey(cacheKey) && (browserListing = (BrowserListing)this.cacheMap.get(cacheKey)) != null) {
            return browserListing;
        }
        try {
            GenericUrl url = new GenericUrl("https://www.browserstack.com/list-of-browsers-and-platforms.json?product=" + productName);
            HttpResponse response = BrowserStackClient.newRequest(this.requestFactory, Method.GET, url).execute();
            browserListing = (BrowserListing)response.parseAs(BrowserListing.class);
        }
        catch (IOException e) {
            throw new BrowserStackException(e.getMessage(), 400);
        }
        if (cache) {
            this.cacheMap.put(cacheKey, browserListing);
        }
        return browserListing;
    }

    protected BrowserStackRequest newRequest(Method method, String path) throws BrowserStackException {
        return this.newRequest(method, path, true);
    }

    protected BrowserStackRequest newRequest(Method method, String path, boolean prependUrl) throws BrowserStackException {
        String urlPath = path == null ? "" : path;
        GenericUrl url = new GenericUrl(prependUrl ? this.baseUrl + urlPath : urlPath);
        return this.signRequest(BrowserStackClient.newRequest(this.requestFactory, method, url));
    }

    protected BrowserStackRequest newRequest(Method method, String path, Map<String, Object> data) throws BrowserStackException {
        return this.newRequest(method, path, data, null);
    }

    protected BrowserStackRequest newRequest(Method method, String path, Map<String, Object> data, Map<String, String> headers) throws BrowserStackException {
        BrowserStackRequest request = this.newRequest(method, path);
        if (headers != null && headers.size() > 0) {
            request.headers(headers);
        }
        if (data != null && data.size() > 0 && request.canContainBody()) {
            try {
                request.header("Content-Type", "application/json").body(JSON_MAPPER.writeValueAsString(data));
            }
            catch (JsonProcessingException e) {
                throw new BrowserStackException((Exception)((Object)e));
            }
        }
        return request;
    }

    protected BrowserStackRequest signRequest(HttpRequest request) {
        this.checkAuthState();
        HttpHeaders header = new HttpHeaders();
        String combined = this.username + ":" + this.accessKey;
        String encoded = new String(Base64.encodeBase64((byte[])combined.getBytes()));
        String credential = "Basic " + encoded;
        header.set("Authorization", (Object)credential);
        request.setHeaders(header);
        return new BrowserStackRequest(request);
    }

    @Override
    public List<Build> getBuilds(Automate.BuildStatus status, int limit, String buildName) throws BrowserStackException {
        BrowserStackRequest httpRequest;
        try {
            httpRequest = this.newRequest(Method.GET, "/builds.json");
        }
        catch (BrowserStackException e) {
            throw new BrowserStackException(e);
        }
        if (limit > 0) {
            httpRequest.queryString("limit", limit);
        }
        if (status != null) {
            httpRequest.queryString("filter", status.name().toLowerCase());
        }
        if (buildName != null && !buildName.isEmpty()) {
            httpRequest.queryString("name", buildName);
        }
        List<Object> buildNodes = Arrays.asList((Object[])httpRequest.asObject(BuildNode[].class));
        ArrayList<Build> builds = new ArrayList<Build>();
        for (BuildNode buildNode : buildNodes) {
            if (buildNode == null || buildNode.getBuild() == null) continue;
            builds.add((Build)buildNode.getBuild().setClient(this));
        }
        return builds;
    }

    @Override
    public List<Build> getBuilds(Automate.BuildStatus status, int limit) throws BrowserStackException {
        return this.getBuilds(status, limit, null);
    }

    @Override
    public List<Build> getBuilds() throws BrowserStackException {
        return this.getBuilds(null, 0);
    }

    @Override
    public List<Build> getBuilds(int limit) throws BrowserStackException {
        return this.getBuilds(null, limit);
    }

    @Override
    public List<Build> getBuilds(Automate.BuildStatus status) throws BrowserStackException {
        return this.getBuilds(status, 0);
    }

    @Override
    public Build getBuild(String buildId) throws BuildNotFound, BrowserStackException {
        try {
            BuildNode buildNode = this.newRequest(Method.GET, "/builds/{buildId}.json").routeParam("buildId", buildId).asObject(BuildNode.class);
            if (buildNode == null) {
                throw new BuildNotFound("Build not found: " + buildId);
            }
            return (Build)buildNode.getBuild().setClient(this);
        }
        catch (BrowserStackObjectNotFound e) {
            throw new BuildNotFound("Build not found: " + buildId);
        }
        catch (BrowserStackException e) {
            throw e;
        }
    }

    @Override
    public Build getBuildByName(@Nonnull String buildName) throws BuildNotFound, BrowserStackException {
        List<Build> build = this.getBuilds(null, 1, buildName);
        if (build.size() == 1) {
            return build.get(0);
        }
        throw new BuildNotFound("Build not found by name: " + buildName);
    }

    @Override
    public boolean deleteBuild(String buildId) throws BrowserStackException {
        ObjectNode result = this.newRequest(Method.DELETE, "/builds/{buildId}.json").routeParam("buildId", buildId).asJsonObject();
        String status = result != null ? result.path("status").asText() : null;
        return status != null && status.equals("ok");
    }

    @Override
    public List<Session> getSessions(String buildId, Automate.BuildStatus status, int limit) throws BuildNotFound, BrowserStackException {
        int totalLimit = limit <= 0 || limit > 1000 ? 1000 : limit;
        int totalRequests = totalLimit / 100;
        if (totalLimit % 100 > 0) {
            ++totalRequests;
        }
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (int currReq = 0; currReq < totalRequests; ++currReq) {
            List<SessionNode> sessionNodes = this.getSessionNodes(buildId, status, totalLimit, currReq * 100);
            for (SessionNode sessionNode : sessionNodes) {
                if (sessionNode == null || sessionNode.getSession() == null) continue;
                sessions.add((Session)sessionNode.getSession().setClient(this));
            }
            if (sessionNodes.size() < 100) break;
        }
        return sessions;
    }

    private List<SessionNode> getSessionNodes(String buildId, Automate.BuildStatus status, int totalLimit, int offset) throws BrowserStackException {
        List<Object> sessionNodes;
        BrowserStackRequest httpRequest = this.newRequest(Method.GET, "/builds/{buildId}/sessions.json").routeParam("buildId", buildId);
        httpRequest.queryString("limit", totalLimit);
        httpRequest.queryString("offset", offset);
        if (status != null) {
            httpRequest.queryString("filter", (Object)status);
        }
        try {
            sessionNodes = Arrays.asList((Object[])httpRequest.asObject(SessionNode[].class));
        }
        catch (BrowserStackObjectNotFound e) {
            throw new BuildNotFound("Build not found: " + buildId);
        }
        catch (BrowserStackException e) {
            throw e;
        }
        return sessionNodes;
    }

    @Override
    public List<Session> getSessions(String buildId) throws BuildNotFound, BrowserStackException {
        return this.getSessions(buildId, null, 0);
    }

    @Override
    public List<Session> getSessions(String buildId, int limit) throws BuildNotFound, BrowserStackException {
        return this.getSessions(buildId, null, limit);
    }

    @Override
    public List<Session> getSessions(String buildId, Automate.BuildStatus status) throws BuildNotFound, BrowserStackException {
        return this.getSessions(buildId, status, 0);
    }

    @Override
    public Session getSession(String sessionId) throws SessionNotFound, BrowserStackException {
        try {
            SessionNode sessionNode = this.newRequest(Method.GET, "/sessions/{sessionId}.json").routeParam("sessionId", sessionId).asObject(SessionNode.class);
            if (sessionNode.getSession() == null) {
                throw new SessionNotFound("Session not found: " + sessionId);
            }
            return (Session)sessionNode.getSession().setClient(this);
        }
        catch (BrowserStackObjectNotFound e) {
            throw new SessionNotFound("Session not found: " + sessionId);
        }
        catch (BrowserStackException e) {
            throw e;
        }
    }

    public static enum Product {
        LIVE,
        AUTOMATE,
        SCREENSHOTS;

    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

