/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.client.util;

import java.util.HashMap;
import java.util.Map;

public class BrowserStackCache<K, T> {
    private static final long DEFAULT_EXPIRY_TIME = 86400000L;
    private static final int DEFAULT_MAX_INIT_ITEMS = 10;
    private final Map<K, BrowserStackCacheObject> cacheMap;
    private final long expiryTime;

    public BrowserStackCache() {
        this(86400000L);
    }

    public BrowserStackCache(long expiryTime) {
        this(expiryTime, 10);
    }

    public BrowserStackCache(long expiryTime, int maxInitItems) {
        this.cacheMap = new HashMap<K, BrowserStackCacheObject>(maxInitItems);
        this.expiryTime = expiryTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        Map<K, BrowserStackCacheObject> map = this.cacheMap;
        synchronized (map) {
            return this.cacheMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, T value) {
        Map<K, BrowserStackCacheObject> map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.put(key, new BrowserStackCacheObject(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(K key) {
        Map<K, BrowserStackCacheObject> map = this.cacheMap;
        synchronized (map) {
            BrowserStackCacheObject c = this.cacheMap.get(key);
            if (c == null) {
                return null;
            }
            long timeDiff = System.currentTimeMillis() - c.created;
            if (timeDiff < 0L || timeDiff >= this.expiryTime) {
                this.cacheMap.remove(key);
                return null;
            }
            return c.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        Map<K, BrowserStackCacheObject> map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<K, BrowserStackCacheObject> map = this.cacheMap;
        synchronized (map) {
            return this.cacheMap.size();
        }
    }

    protected class BrowserStackCacheObject {
        public final T value;
        public final long created;

        protected BrowserStackCacheObject(T value) {
            this.value = value;
            this.created = System.currentTimeMillis();
        }
    }
}

