/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.appautomate;

import com.browserstack.appautomate.AppAutomate;
import com.browserstack.automate.Automate;
import com.browserstack.automate.exception.AppAutomateException;
import com.browserstack.automate.exception.BuildNotFound;
import com.browserstack.automate.exception.InvalidFileExtensionException;
import com.browserstack.automate.exception.SessionNotFound;
import com.browserstack.automate.model.AppUploadResponse;
import com.browserstack.automate.model.Build;
import com.browserstack.automate.model.Session;
import com.browserstack.client.BrowserStackClient;
import com.browserstack.client.BrowserStackRequest;
import com.browserstack.client.exception.BrowserStackException;
import com.browserstack.client.util.Tools;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.MultipartContent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import javax.annotation.Nonnull;

public class AppAutomateClient
extends BrowserStackClient
implements AppAutomate {
    private static final String BASE_URL = "https://api-cloud.browserstack.com/app-automate";

    public AppAutomateClient(String username, String accessKey) {
        super(System.getProperty("browserstack.app-automate.api", BASE_URL), username, accessKey);
    }

    @Override
    public Session getSession(String sessionId) throws SessionNotFound, AppAutomateException {
        try {
            return super.getSession(sessionId);
        }
        catch (BrowserStackException e) {
            throw new AppAutomateException(e);
        }
    }

    @Override
    public AppUploadResponse uploadApp(String filePath) throws AppAutomateException, FileNotFoundException, InvalidFileExtensionException {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                throw new FileNotFoundException("File not found at " + filePath);
            }
            if (!filePath.endsWith(".apk") && !filePath.endsWith(".ipa")) {
                throw new InvalidFileExtensionException("File extension should be only .apk or .ipa.");
            }
            MultipartContent content = new MultipartContent().setMediaType(new HttpMediaType("multipart/form-data").setParameter("boundary", "__END_OF_PART__"));
            FileContent fileContent = new FileContent("multipart/form-data", file);
            MultipartContent.Part part = new MultipartContent.Part((HttpContent)fileContent);
            part.setHeaders(new HttpHeaders().set("Content-Disposition", (Object)String.format("form-data; name=\"file\"; filename=\"%s\"", file.getName())));
            content.addPart(part);
            BrowserStackRequest request = this.newRequest(BrowserStackClient.Method.POST, "/upload");
            request.getHttpRequest().setReadTimeout(0);
            AppUploadResponse appUploadResponse = request.body((HttpContent)content).asObject(AppUploadResponse.class);
            if (appUploadResponse == null || Tools.isStringEmpty(appUploadResponse.getAppUrl())) {
                throw new AppAutomateException("App upload failed!", 0);
            }
            return appUploadResponse;
        }
        catch (BrowserStackException e) {
            throw new AppAutomateException(e);
        }
    }

    @Override
    public List<Build> getBuilds(Automate.BuildStatus status, int limit) throws AppAutomateException {
        try {
            return super.getBuilds(status, limit);
        }
        catch (BrowserStackException e) {
            throw new AppAutomateException(e);
        }
    }

    @Override
    public List<Build> getBuilds() throws AppAutomateException {
        return this.getBuilds(null, 0);
    }

    @Override
    public List<Build> getBuilds(int limit) throws AppAutomateException {
        return this.getBuilds(null, limit);
    }

    @Override
    public List<Build> getBuilds(Automate.BuildStatus status) throws AppAutomateException {
        return this.getBuilds(status, 0);
    }

    @Override
    public Build getBuild(String buildId) throws BuildNotFound, AppAutomateException {
        try {
            return super.getBuild(buildId);
        }
        catch (BrowserStackException e) {
            throw new AppAutomateException(e);
        }
    }

    @Override
    public final Build getBuildByName(@Nonnull String buildName) throws BuildNotFound, AppAutomateException {
        try {
            return super.getBuildByName(buildName);
        }
        catch (BrowserStackException e) {
            throw new AppAutomateException(e);
        }
    }

    @Override
    public boolean deleteBuild(String buildId) throws AppAutomateException {
        try {
            return super.deleteBuild(buildId);
        }
        catch (BrowserStackException e) {
            throw new AppAutomateException(e);
        }
    }

    @Override
    public List<Session> getSessions(String buildId, Automate.BuildStatus status, int limit) throws BuildNotFound, AppAutomateException {
        try {
            return super.getSessions(buildId, status, limit);
        }
        catch (BrowserStackException e) {
            throw new AppAutomateException(e);
        }
    }

    @Override
    public List<Session> getSessions(String buildId) throws BuildNotFound, AppAutomateException {
        return this.getSessions(buildId, null, 0);
    }

    @Override
    public List<Session> getSessions(String buildId, int limit) throws BuildNotFound, AppAutomateException {
        return this.getSessions(buildId, null, limit);
    }

    @Override
    public List<Session> getSessions(String buildId, Automate.BuildStatus status) throws BuildNotFound, AppAutomateException {
        return this.getSessions(buildId, status, 0);
    }
}

