/*
 * Decompiled with CFR 0.152.
 */
package com.cardpay.sdk.api;

import com.cardpay.sdk.model.AuthenticationDataResponse;
import com.cardpay.sdk.model.ChangeSubscriptionStatusClaimResponse;
import com.cardpay.sdk.model.FilingRequest;
import com.cardpay.sdk.model.PlanDataList;
import com.cardpay.sdk.model.PlanUpdateRequest;
import com.cardpay.sdk.model.PlanUpdateResponse;
import com.cardpay.sdk.model.RecurringCreationRequest;
import com.cardpay.sdk.model.RecurringGatewayCreationResponse;
import com.cardpay.sdk.model.RecurringPatchRequest;
import com.cardpay.sdk.model.RecurringPlanRequest;
import com.cardpay.sdk.model.RecurringPlanResponse;
import com.cardpay.sdk.model.RecurringResponse;
import com.cardpay.sdk.model.RecurringUpdateResponse;
import com.cardpay.sdk.model.RecurringsList;
import com.cardpay.sdk.model.SubscriptionGetResponse;
import com.cardpay.sdk.model.SubscriptionList;
import com.cardpay.sdk.model.SubscriptionUpdateRequest;
import com.cardpay.sdk.model.SubscriptionUpdateResponse;
import java.time.OffsetDateTime;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface RecurringsApi {
    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/recurring_filings")
    public Call<RecurringGatewayCreationResponse> createFiling(@Body FilingRequest var1);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/recurring_plans")
    public Call<RecurringPlanResponse> createPlan(@Body RecurringPlanRequest var1);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/recurrings")
    public Call<RecurringGatewayCreationResponse> createRecurring(@Body RecurringCreationRequest var1);

    @DELETE(value="api/recurring_plans/{plan_id}")
    public Call<Void> deletePlan(@Path(value="plan_id") String var1);

    @GET(value="api/recurrings/{recurringId}/threedsecure")
    public Call<AuthenticationDataResponse> getAuthenticationData1(@Path(value="recurringId") String var1);

    @GET(value="api/recurring_subscriptions/{subscriptionId}/change_status_claims/{claimId}")
    public Call<ChangeSubscriptionStatusClaimResponse> getChangeStatusClaim(@Path(value="claimId") String var1, @Path(value="subscriptionId") String var2);

    @GET(value="api/recurring_filings/{filingId}")
    public Call<RecurringResponse> getFiling(@Path(value="filingId") String var1);

    @GET(value="api/recurring_plans/{plan_id}")
    public Call<RecurringPlanResponse> getPlan(@Path(value="plan_id") String var1);

    @GET(value="api/recurring_plans")
    public Call<PlanDataList> getPlans(@Query(value="request_id") String var1, @Query(value="max_count") Integer var2, @Query(value="offset") Integer var3, @Query(value="sort_order") String var4);

    @GET(value="api/recurrings/{recurringId}")
    public Call<RecurringResponse> getRecurring(@Path(value="recurringId") String var1);

    @GET(value="api/recurrings")
    public Call<RecurringsList> getRecurrings(@Query(value="request_id") String var1, @Query(value="currency") String var2, @Query(value="end_time") OffsetDateTime var3, @Query(value="max_count") Integer var4, @Query(value="merchant_order_id") String var5, @Query(value="payment_method") String var6, @Query(value="recurring_types") List<String> var7, @Query(value="sort_order") String var8, @Query(value="start_time") OffsetDateTime var9, @Query(value="type") String var10);

    @GET(value="api/recurring_subscriptions/{subscriptionId}")
    public Call<SubscriptionGetResponse> getSubscription(@Path(value="subscriptionId") String var1);

    @GET(value="api/recurring_subscriptions")
    public Call<SubscriptionList> getSubscriptions(@Query(value="request_id") String var1, @Query(value="account_id") String var2, @Query(value="currency") String var3, @Query(value="end_time") OffsetDateTime var4, @Query(value="max_count") Integer var5, @Query(value="offset") Integer var6, @Query(value="plan_id") String var7, @Query(value="sort_order") String var8, @Query(value="start_time") OffsetDateTime var9, @Query(value="status") String var10, @Query(value="type") String var11);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/recurring_plans/{plan_id}")
    public Call<PlanUpdateResponse> updatePlan(@Path(value="plan_id") String var1, @Body PlanUpdateRequest var2);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/recurrings/{recurringId}")
    public Call<RecurringUpdateResponse> updateRecurring(@Path(value="recurringId") String var1, @Body RecurringPatchRequest var2);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/recurring_subscriptions/{subscriptionId}")
    public Call<SubscriptionUpdateResponse> updateSubscription(@Path(value="subscriptionId") String var1, @Body SubscriptionUpdateRequest var2);
}

