/*
 * Decompiled with CFR 0.152.
 */
package com.cardpay.sdk.client;

import com.cardpay.sdk.api.AuthApi;
import com.cardpay.sdk.client.DefaultTokenProvider;
import com.cardpay.sdk.client.GsonCustomConverterFactory;
import com.cardpay.sdk.client.JSON;
import com.cardpay.sdk.client.TokenManagerInterceptor;
import com.cardpay.sdk.client.UserAgentInterceptor;
import com.cardpay.sdk.model.ApiError;
import com.cardpay.sdk.model.PaymentCallback;
import com.cardpay.sdk.model.PayoutCallback;
import com.cardpay.sdk.model.RecurringCallback;
import com.cardpay.sdk.model.RefundCallback;
import com.cardpay.sdk.model.Request;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class ApiClient {
    public static final String USER_AGENT = "CardpaySdk/3.39.13/Java";
    public static final Optional<ProxySelector> ENV_VAR_PROXY_SELECTOR = ApiClient.createEnvVarProxySelector();
    private TokenProvider tokenProvider;
    private String baseUrl;
    private String terminalCode;
    private String password;
    private Duration connectTimeout = Duration.ofMillis(40000L);
    private Duration readTimeout = Duration.ofMillis(60000L);
    private Duration callTimeout = Duration.ofMillis(100000L);
    private Map<String, Interceptor> apiAuthorizations;
    private OkHttpClient.Builder okBuilder;
    private Retrofit.Builder adapterBuilder;
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private Interceptor authInterceptor;

    public ApiClient() {
        this.apiAuthorizations = new LinkedHashMap<String, Interceptor>();
    }

    public ApiClient(String baseUrl) {
        this();
        this.baseUrl = !baseUrl.endsWith("/") ? baseUrl + "/" : baseUrl;
    }

    public ApiClient(String baseUrl, TokenProvider tokenProvider) {
        this(baseUrl);
        this.tokenProvider = tokenProvider;
    }

    public ApiClient(String baseUrl, String terminalCode, String password) {
        this(baseUrl);
        this.terminalCode = terminalCode;
        this.password = password;
    }

    public ApiClient(String baseUrl, Interceptor authInterceptor) {
        this(baseUrl);
        this.authInterceptor = authInterceptor;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setCallTimeout(Duration callTimeout) {
        this.callTimeout = callTimeout;
    }

    private void createDefaultAdapter() {
        this.okBuilder = new OkHttpClient.Builder().addInterceptor((Interceptor)new UserAgentInterceptor(USER_AGENT)).connectTimeout(this.connectTimeout).readTimeout(this.readTimeout).callTimeout(this.callTimeout);
        ENV_VAR_PROXY_SELECTOR.ifPresent(arg_0 -> ((OkHttpClient.Builder)this.okBuilder).proxySelector(arg_0));
        this.interceptors.forEach(v -> this.okBuilder.addInterceptor(v));
        this.adapterBuilder = new Retrofit.Builder().baseUrl(this.baseUrl).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonCustomConverterFactory.create(new JSON().getGson()));
        if (this.authInterceptor == null) {
            this.addAuthorization("Bearer", new TokenManagerInterceptor(Optional.ofNullable(this.tokenProvider).orElseGet(() -> new DefaultTokenProvider(this.createService(AuthApi.class), this.terminalCode, this.password))));
        } else {
            this.okBuilder.addInterceptor(this.authInterceptor);
        }
    }

    private Retrofit.Builder getAdapterBuilder() {
        if (this.adapterBuilder == null) {
            this.createDefaultAdapter();
        }
        return this.adapterBuilder;
    }

    public <S> S createService(Class<S> serviceClass) {
        return (S)this.getAdapterBuilder().client(this.okBuilder.build()).build().create(serviceClass);
    }

    public ApiClient addLogging(HttpLoggingInterceptor.Level level) {
        this.interceptors.add((Interceptor)new HttpLoggingInterceptor().setLevel(level));
        return this;
    }

    public ApiClient addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    private ApiClient addAuthorization(String authName, Interceptor authorization) {
        if (this.apiAuthorizations.containsKey(authName)) {
            throw new RuntimeException("auth name \"" + authName + "\" already in api authorizations");
        }
        this.apiAuthorizations.put(authName, authorization);
        this.okBuilder.addInterceptor(authorization);
        return this;
    }

    public static Request uuidRequest() {
        return new Request().id(UUID.randomUUID().toString()).time(OffsetDateTime.now().atZoneSameInstant(ZoneOffset.UTC).toOffsetDateTime());
    }

    public static <T> T fromJson(String json, Class<T> callbackClass) {
        try {
            return (T)new JSON().getGson().fromJson(json, callbackClass);
        }
        catch (JsonSyntaxException e) {
            throw new CallbackException("Json parse exception", e);
        }
    }

    public static Response doGet(String url) throws ApiException {
        okhttp3.Request request = new Request.Builder().url(url).addHeader("User-Agent", USER_AGENT).build();
        OkHttpClient.Builder okClientBuilder = new OkHttpClient.Builder();
        ENV_VAR_PROXY_SELECTOR.ifPresent(arg_0 -> ((OkHttpClient.Builder)okClientBuilder).proxySelector(arg_0));
        OkHttpClient client = okClientBuilder.build();
        try {
            return client.newCall(request).execute();
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    public static String getContent(ResponseBody responseBody) {
        return Optional.ofNullable(responseBody).map(body -> new Scanner(body.byteStream()).useDelimiter("\\A")).filter(Scanner::hasNext).map(Scanner::next).orElse(null);
    }

    private static Optional<ProxySelector> createEnvVarProxySelector() {
        final String proxyUrl = ApiClient.getEnvVar("HTTPS_PROXY").orElse(ApiClient.getEnvVar("HTTP_PROXY").orElse(null));
        if (proxyUrl == null) {
            return Optional.empty();
        }
        final Optional<List> noProxy = ApiClient.getEnvVar("NO_PROXY").map(v -> v.replace("*", "")).map(v -> Arrays.asList(v.split(",")));
        return Optional.of(new ProxySelector(){
            private final Proxy envVarProxy = this.createEnvVarProxy();

            @Override
            public List<Proxy> select(URI uri) {
                if (noProxy.isPresent() && ((List)noProxy.get()).stream().anyMatch(v -> uri.getHost().endsWith((String)v))) {
                    return Collections.singletonList(Proxy.NO_PROXY);
                }
                return Collections.singletonList(this.envVarProxy);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }

            private Proxy createEnvVarProxy() {
                String proxyPath = proxyUrl.replace("http://", "").replace("https://", "");
                String[] proxyPathSplit = proxyPath.split(":");
                String proxyHostname = proxyPathSplit[0];
                int proxyPort = proxyPathSplit.length > 1 ? Integer.parseInt(proxyPathSplit[1]) : 3128;
                return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHostname, proxyPort));
            }
        });
    }

    private static Optional<String> getEnvVar(String name) {
        return Optional.ofNullable(System.getenv("HTTPS_PROXY")).filter(v -> !v.isEmpty());
    }

    public static IOException parseApiError(Response response) throws IOException {
        if (response.body() == null) {
            return new IOException("Unknown API error");
        }
        ApiError apiError = (ApiError)new JSON().getGson().fromJson(response.body().string(), ApiError.class);
        return new ApiException(apiError.getMessage(), apiError.getName());
    }

    public static interface TokenProvider {
        public String obtainToken() throws IOException;

        public String obtainNewToken() throws IOException;
    }

    public static class CallbackProcessor {
        private JSON json;
        private String callbackSecret;
        private Map<String, Consumer<?>> handlers = new TreeMap();

        public CallbackProcessor(String callbackSecret) {
            this.json = new JSON();
            this.callbackSecret = callbackSecret;
        }

        public <T> CallbackProcessor registerHandler(Class<T> clazz, Consumer<T> handler) {
            this.handlers.put(clazz.getName(), handler);
            return this;
        }

        public void process(String json, String signature) {
            if (!this.isValidSignature(json, signature)) {
                throw new InvalidSignatureException("Invalid callback signature");
            }
            Object obj = this.parseCallback(json);
            Consumer<?> handler = this.handlers.get(obj.getClass().getName());
            if (handler == null) {
                throw new CallbackException("Not found handler for callback class " + obj.getClass().getName());
            }
            handler.accept(obj);
        }

        public <T> T fromJson(String json, Class<T> callbackClass) {
            try {
                return (T)this.json.getGson().fromJson(json, callbackClass);
            }
            catch (JsonSyntaxException e) {
                throw new CallbackException("Json parse exception", e);
            }
        }

        public Object parseCallback(String json) {
            if (json == null || json.isEmpty()) {
                throw new CallbackException("Could not parse null or empty callback json.");
            }
            if (json.contains("refund_data")) {
                return this.fromJson(json, RefundCallback.class);
            }
            if (json.contains("recurring_data")) {
                return this.fromJson(json, RecurringCallback.class);
            }
            if (json.contains("payout_data")) {
                return this.fromJson(json, PayoutCallback.class);
            }
            if (json.contains("payment_data")) {
                return this.fromJson(json, PaymentCallback.class);
            }
            throw new CallbackException("Could not parse callback json.");
        }

        public boolean isValidSignature(String json, String signature) {
            return signature != null && !signature.isEmpty() && signature.equals(this.calcSignature(json));
        }

        public String calcSignature(String json) {
            String message = json + this.callbackSecret;
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-512");
                digest.update(message.getBytes(StandardCharsets.UTF_8));
                int outputStringLength = digest.getDigestLength() * 2;
                String result = new BigInteger(1, digest.digest()).toString(16);
                while (result.length() < outputStringLength) {
                    result = "0".concat(result);
                }
                return result;
            }
            catch (NoSuchAlgorithmException ex) {
                return null;
            }
        }
    }

    public static class InvalidSignatureException
    extends RuntimeException {
        public InvalidSignatureException() {
        }

        public InvalidSignatureException(String message) {
            super(message);
        }

        public InvalidSignatureException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class CallbackException
    extends RuntimeException {
        public CallbackException() {
        }

        public CallbackException(String message) {
            super(message);
        }

        public CallbackException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ApiException
    extends IOException {
        private String code = "INVALID_API_REQUEST";

        public ApiException() {
        }

        public ApiException(String message) {
            super(message);
        }

        public ApiException(String message, Throwable cause) {
            super(message, cause);
        }

        public ApiException(String message, String code) {
            super(message);
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

