/*
 * Decompiled with CFR 0.152.
 */
package com.cardpay.sdk.client;

import com.cardpay.sdk.api.AuthApi;
import com.cardpay.sdk.client.ApiClient;
import com.cardpay.sdk.client.JSON;
import com.cardpay.sdk.model.ApiTokens;
import com.cardpay.sdk.model.OAuthError;
import java.io.IOException;
import retrofit2.Response;

class DefaultTokenProvider
implements ApiClient.TokenProvider {
    private static final long TOKEN_MIN_VALIDITY = 10000L;
    private final JSON json = new JSON();
    private final String terminalCode;
    private final String password;
    private final AuthApi authApi;
    private ThreadLocal<ApiTokens> tokens = ThreadLocal.withInitial(() -> null);

    public DefaultTokenProvider(AuthApi authApi, String terminalCode, String password) {
        this.authApi = authApi;
        this.terminalCode = terminalCode;
        this.password = password;
    }

    @Override
    public String obtainToken() throws IOException {
        ApiTokens token = this.tokens.get();
        return token == null || this.isExpired(token.getExpiresIn()) ? this.obtainNewToken() : token.getAccessToken();
    }

    @Override
    public String obtainNewToken() throws IOException {
        ApiTokens token = this.tokens.get();
        try {
            token = token == null || token.getRefreshToken() == null || this.isExpired(token.getRefreshExpiresIn()) ? this.obtainByPassword(this.password, this.terminalCode) : this.obtainByRefreshToken(token.getRefreshToken());
        }
        catch (IOException e) {
            token = this.obtainByPassword(this.password, this.terminalCode);
        }
        token.setExpiresIn(token.getExpiresIn() * 1000L + System.currentTimeMillis());
        token.setRefreshExpiresIn(token.getRefreshExpiresIn() * 1000L + System.currentTimeMillis());
        this.tokens.set(token);
        return token.getAccessToken();
    }

    private ApiTokens obtainByRefreshToken(String refreshToken) throws IOException {
        Response response = this.authApi.obtainTokens("refresh_token", "", refreshToken, "").execute();
        if (response.isSuccessful()) {
            return (ApiTokens)response.body();
        }
        throw this.parseAuthError((Response<ApiTokens>)response);
    }

    private ApiTokens obtainByPassword(String password, String terminalCode) throws IOException {
        Response response = this.authApi.obtainTokens("password", password, "", terminalCode).execute();
        if (response.isSuccessful()) {
            return (ApiTokens)response.body();
        }
        throw this.parseAuthError((Response<ApiTokens>)response);
    }

    private IOException parseAuthError(Response<ApiTokens> response) throws IOException {
        if (response.errorBody() == null) {
            return new IOException("Unknown auth error");
        }
        OAuthError error = (OAuthError)this.json.getGson().fromJson(response.errorBody().string(), OAuthError.class);
        return new ApiClient.ApiException(error.getMessage());
    }

    private boolean isExpired(long expiresAt) {
        return expiresAt - System.currentTimeMillis() < 10000L;
    }
}

