/*
 * Decompiled with CFR 0.152.
 */
package com.cardpay.sdk.client;

import com.cardpay.sdk.client.ApiClient;
import com.cardpay.sdk.client.JSON;
import com.cardpay.sdk.model.OAuthError;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class TokenManagerInterceptor
implements Interceptor {
    private final JSON json = new JSON();
    private final ApiClient.TokenProvider tokenProvider;

    TokenManagerInterceptor(ApiClient.TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (request.url().encodedPath().contains("/api/auth/token")) {
            return chain.proceed(request);
        }
        Response response = this.proceed(chain, request, this.tokenProvider.obtainToken());
        if (!response.isSuccessful() && response.body() != null) {
            if (this.isBadRequest(response)) {
                throw ApiClient.parseApiError(response);
            }
            OAuthError error = (OAuthError)this.json.getGson().fromJson(response.body().string(), OAuthError.class);
            if (error.getName() != OAuthError.NameEnum.TOKEN) {
                throw new IOException(error.getMessage());
            }
            response = this.proceed(chain, request, this.tokenProvider.obtainNewToken());
            if (!response.isSuccessful() && response.body() != null) {
                throw ApiClient.parseApiError(response);
            }
        }
        return response;
    }

    private boolean isBadRequest(Response response) {
        return response.code() >= 400;
    }

    private Response proceed(Interceptor.Chain chain, Request request, String accessToken) throws IOException {
        return chain.proceed(request.newBuilder().addHeader("Authorization", "Bearer " + accessToken).build());
    }
}

