/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.wicket.navigation;

import com.cedarsoft.wicket.navigation.HeadedNavigationComponent;
import com.cedarsoft.wicket.navigation.HeadedNavigationTestPage;
import com.cedarsoft.wicket.navigation.LinkProvider;
import com.cedarsoft.wicket.navigation.LinksDataView;
import com.cedarsoft.wicket.navigation.NavigationComponent;
import com.cedarsoft.wicket.navigation.NavigationTestPage;
import java.util.Arrays;
import javax.annotation.Nonnull;
import junit.framework.TestCase;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.util.tester.TagTester;
import org.apache.wicket.util.tester.WicketTester;
import org.jetbrains.annotations.NonNls;

public class NavigationTest
extends TestCase {
    private WicketTester wicketTester;
    private LinksDataView<LinkProvider> linksDataView;

    protected void setUp() throws Exception {
        super.setUp();
        this.wicketTester = new WicketTester();
        LinkProvider linkProvider = new LinkProvider(){

            @Nonnull
            public WebMarkupContainer createLink(@Nonnull @NonNls String id) {
                return new ExternalLink(id, "http://www.heise.de");
            }

            @Nonnull
            public WebComponent createLabel(@Nonnull @NonNls String id) {
                return new Label(id, "heise");
            }
        };
        LinkProvider linkProvider2 = new LinkProvider(){

            @Nonnull
            public WebMarkupContainer createLink(@Nonnull @NonNls String id) {
                return new ExternalLink(id, "http://www.spiegel.de");
            }

            @Nonnull
            public WebComponent createLabel(@Nonnull @NonNls String id) {
                return new Label(id, "spiegel");
            }
        };
        this.linksDataView = new LinksDataView((IDataProvider)new ListDataProvider(Arrays.asList(linkProvider, linkProvider2)));
    }

    public void testSetup() {
        NavigationTest.assertEquals((int)2, (int)this.linksDataView.getDataProvider().size());
    }

    public void testNav() {
        this.wicketTester.startPage((Page)new NavigationTestPage(this.linksDataView));
        this.wicketTester.assertComponent("navigationComponent", NavigationComponent.class);
        NavigationTest.assertNotNull((Object)this.wicketTester.getComponentFromLastRenderedPage("navigationComponent:navigationUl"));
        NavigationTest.assertNotNull((Object)this.wicketTester.getComponentFromLastRenderedPage("navigationComponent:navigationUl:links"));
        TagTester tag = this.wicketTester.getTagByWicketId("navigationUl");
        NavigationTest.assertEquals((String)"<ul class=\"navigation\" wicket:id=\"navigationUl\" id=\"small\">\n    <li wicket:id=\"links\"><a wicket:id=\"link\" href=\"http://www.heise.de\"><span wicket:id=\"label\">heise</span></a></li><li wicket:id=\"links\"><a wicket:id=\"link\" href=\"http://www.spiegel.de\"><span wicket:id=\"label\">spiegel</span></a></li>\n  </ul>", (String)tag.getMarkup());
    }

    public void testHeadlineNav() {
        this.wicketTester.startPage((Page)new HeadedNavigationTestPage(this.linksDataView));
        this.wicketTester.assertComponent("navigationComponent", HeadedNavigationComponent.class);
        this.wicketTester.assertComponent("navigationComponent:headline", Label.class);
        NavigationTest.assertEquals((Object)"the headline", (Object)this.wicketTester.getComponentFromLastRenderedPage("navigationComponent:headline").getDefaultModelObject());
        NavigationTest.assertNotNull((Object)this.wicketTester.getComponentFromLastRenderedPage("navigationComponent:navigationUl"));
        NavigationTest.assertNotNull((Object)this.wicketTester.getComponentFromLastRenderedPage("navigationComponent:navigationUl:links"));
        TagTester tag = this.wicketTester.getTagByWicketId("navigationComponent");
        NavigationTest.assertEquals((String)"<div wicket:id=\"navigationComponent\"><wicket:panel>\n  <wicket:child><wicket:extend>\n  <div class=\"navigationHeadline\" wicket:id=\"headline\">the headline</div>\n</wicket:extend></wicket:child>\n\n  <ul class=\"navigation\" wicket:id=\"navigationUl\" id=\"small\">\n    <li wicket:id=\"links\"><a wicket:id=\"link\" href=\"http://www.heise.de\"><span wicket:id=\"label\">heise</span></a></li><li wicket:id=\"links\"><a wicket:id=\"link\" href=\"http://www.spiegel.de\"><span wicket:id=\"label\">spiegel</span></a></li>\n  </ul>\n\n</wicket:panel></div>", (String)tag.getMarkup());
    }
}

