/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.wicket.navigation;

import com.cedarsoft.wicket.navigation.LinkProvider;
import javax.annotation.Nonnull;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.jetbrains.annotations.NonNls;

public class LinksDataView<T extends LinkProvider>
extends DataView<T> {
    @Nonnull
    @NonNls
    public static final String ID = "links";
    @Nonnull
    @NonNls
    static final String ID_LINK = "link";
    @Nonnull
    @NonNls
    static final String ID_LABEL = "label";

    public LinksDataView(@Nonnull IDataProvider<T> dataProvider) {
        super(ID, dataProvider);
    }

    protected void populateItem(@Nonnull Item<T> item) {
        LinkProvider linkProvider = (LinkProvider)item.getModelObject();
        WebMarkupContainer link = linkProvider.createLink(ID_LINK);
        if (!ID_LINK.equals(link.getId())) {
            throw new IllegalStateException("Link must have the ID set to link");
        }
        WebComponent label = linkProvider.createLabel(ID_LABEL);
        if (!ID_LABEL.equals(label.getId())) {
            throw new IllegalStateException("Label must have the ID set to label");
        }
        link.add(new Component[]{label});
        item.add(new Component[]{link});
    }
}

