/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.wicket.navigation;

import com.cedarsoft.wicket.navigation.LinksDataView;
import javax.annotation.Nonnull;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.StyleSheetReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class NavigationComponent
extends Panel {
    @NonNls
    public static final String NAVIGATION_UL = "navigationUl";

    public NavigationComponent(@Nonnull @NonNls String id, @Nonnull LinksDataView<?> dataView) {
        this(id, dataView, null);
    }

    public NavigationComponent(@Nonnull @NonNls String id, final @Nonnull LinksDataView<?> dataView, @Nullable ResourceReference styleSheetReference) {
        super(id);
        if (styleSheetReference == null) {
            this.add(new Component[]{new EmptyPanel("styleSheet")});
        } else {
            this.add(new Component[]{new StyleSheetReference("styleSheet", styleSheetReference)});
        }
        WebMarkupContainer container = new WebMarkupContainer(NAVIGATION_UL);
        this.add(new Component[]{container});
        container.add(new Component[]{dataView});
        container.add(new IBehavior[]{new AbstractBehavior(){

            public void onComponentTag(@Nonnull Component component, @Nonnull ComponentTag tag) {
                if (dataView.getRowCount() > 6) {
                    tag.put("id", (CharSequence)"big");
                } else {
                    tag.put("id", (CharSequence)"small");
                }
            }
        }});
    }
}

