/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveMap<K, V>
implements Map<K, V> {
    private LinkedHashMap<K, V> map;

    public CaseInsensitiveMap() {
        this.map = new LinkedHashMap();
    }

    public CaseInsensitiveMap(int initialCapacity) {
        this.map = new LinkedHashMap(initialCapacity);
    }

    public CaseInsensitiveMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        this.putAll(map);
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.get(new CaseInsensitiveString(keyString));
        }
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (key instanceof String) {
            CaseInsensitiveString newKey = new CaseInsensitiveString((String)key);
            if (this.map.containsKey(newKey)) {
                this.map.remove(newKey);
            }
            return this.map.put(newKey, value);
        }
        return this.map.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.containsKey(new CaseInsensitiveString(keyString));
        }
        return this.map.containsKey(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.remove(new CaseInsensitiveString(keyString));
        }
        return this.map.remove(key);
    }

    @Override
    public Set<K> keySet() {
        LinkedHashSet<K> returnedKeySet = new LinkedHashSet<K>(this.map.keySet().size());
        for (K key : this.map.keySet()) {
            returnedKeySet.add(key instanceof CaseInsensitiveString ? key.toString() : key);
        }
        return returnedKeySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> insensitiveEntrySet = this.map.entrySet();
        LinkedHashSet<Map.Entry<K, V>> returnEntrySet = new LinkedHashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry : insensitiveEntrySet) {
            if (entry.getKey() instanceof CaseInsensitiveString) {
                CaseInsensitiveString key = (CaseInsensitiveString)entry.getKey();
                entry = new AbstractMap.SimpleImmutableEntry<String, V>(key.toString(), entry.getValue());
            }
            returnEntrySet.add(entry);
        }
        return returnEntrySet;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    private static class CaseInsensitiveString {
        private final String caseInsensitiveString;

        private CaseInsensitiveString(String string) {
            this.caseInsensitiveString = string;
        }

        public String toString() {
            return this.caseInsensitiveString;
        }

        public int hashCode() {
            if (this.caseInsensitiveString == null) {
                return 0;
            }
            return this.caseInsensitiveString.toLowerCase().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CaseInsensitiveString)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            CaseInsensitiveString other = (CaseInsensitiveString)obj;
            if (this.caseInsensitiveString == null) {
                return other.caseInsensitiveString == null;
            }
            return this.caseInsensitiveString.equalsIgnoreCase(other.caseInsensitiveString);
        }
    }
}

