/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

public final class StringUtilities {
    private static final char[] _hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String FOLDER_SEPARATOR = "/";

    private StringUtilities() {
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return str1 == str2;
        }
        return str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean equalsWithTrim(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.trim().equals(s2.trim());
    }

    public static boolean equalsIgnoreCaseWithTrim(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.trim().equalsIgnoreCase(s2.trim());
    }

    public static boolean isEmpty(String s) {
        return StringUtilities.trimLength(s) == 0;
    }

    public static boolean hasContent(String s) {
        return StringUtilities.trimLength(s) != 0;
    }

    public static int length(String s) {
        return s == null ? 0 : s.length();
    }

    public static int trimLength(String s) {
        return s == null ? 0 : s.trim().length();
    }

    public static int lastIndexOf(String path, char ch) {
        if (path == null) {
            return -1;
        }
        return path.lastIndexOf(ch);
    }

    public static byte[] decode(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            return null;
        }
        byte[] bytes = new byte[len / 2];
        int pos = 0;
        for (int i = 0; i < len; i += 2) {
            byte hi = (byte)Character.digit(s.charAt(i), 16);
            byte lo = (byte)Character.digit(s.charAt(i + 1), 16);
            bytes[pos++] = (byte)(hi * 16 + lo);
        }
        return bytes;
    }

    public static String encode(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length << 1);
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            sb.append(StringUtilities.convertDigit(bytes[i] >> 4));
            sb.append(StringUtilities.convertDigit(bytes[i] & 0xF));
        }
        return sb.toString();
    }

    private static char convertDigit(int value) {
        return _hex[value & 0xF];
    }

    public static int count(String s, char c) {
        if (StringUtilities.isEmpty(s)) {
            return 0;
        }
        int count = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }
}

