/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.BigIntegerConversions;
import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;

final class BigDecimalConversions {
    static final BigDecimal GRAND = BigDecimal.valueOf(1000L);

    private BigDecimalConversions() {
    }

    static Instant toInstant(Object from, Converter converter) {
        BigDecimal seconds = (BigDecimal)from;
        BigDecimal nanos = seconds.remainder(BigDecimal.ONE);
        return Instant.ofEpochSecond(seconds.longValue(), nanos.movePointRight(9).longValue());
    }

    static Duration toDuration(Object from, Converter converter) {
        BigDecimal seconds = (BigDecimal)from;
        BigDecimal nanos = seconds.remainder(BigDecimal.ONE);
        return Duration.ofSeconds(seconds.longValue(), nanos.movePointRight(9).longValue());
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return BigDecimalConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return BigDecimalConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        return BigDecimalConversions.toZonedDateTime(from, converter).toOffsetDateTime();
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return BigDecimalConversions.toInstant(from, converter).atZone(converter.getOptions().getZoneId());
    }

    static Date toDate(Object from, Converter converter) {
        return Date.from(BigDecimalConversions.toInstant(from, converter));
    }

    static java.sql.Date toSqlDate(Object from, Converter converter) {
        return new java.sql.Date(BigDecimalConversions.toInstant(from, converter).toEpochMilli());
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return Timestamp.from(BigDecimalConversions.toInstant(from, converter));
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        return ((BigDecimal)from).toBigInteger();
    }

    static String toString(Object from, Converter converter) {
        return ((BigDecimal)from).stripTrailingZeros().toPlainString();
    }

    static UUID toUUID(Object from, Converter converter) {
        BigInteger bigInt = ((BigDecimal)from).toBigInteger();
        return BigIntegerConversions.toUUID(bigInt, converter);
    }
}

