/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MapUtilities {
    private MapUtilities() {
    }

    public static <T> T get(Map<?, T> map, Object key, T def) {
        T val = map.get(key);
        return val == null ? def : val;
    }

    public static <T extends Throwable> Object getOrThrow(Map<?, ?> map, Object key, T throwable) throws T {
        if (map == null) {
            throw new NullPointerException("Map parameter cannot be null");
        }
        if (throwable == null) {
            throw new NullPointerException("Throwable object cannot be null");
        }
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw throwable;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static <T> Map<Class<?>, Set<T>> dupe(Map<Class<?>, Set<T>> other, boolean unmodifiable) {
        LinkedHashMap newItemsAssocToClass = new LinkedHashMap();
        for (Map.Entry<Class<?>, Set<T>> entry : other.entrySet()) {
            LinkedHashSet itemsAssocToClass = new LinkedHashSet(entry.getValue());
            if (unmodifiable) {
                newItemsAssocToClass.computeIfAbsent(entry.getKey(), k -> Collections.unmodifiableSet(itemsAssocToClass));
                continue;
            }
            newItemsAssocToClass.computeIfAbsent(entry.getKey(), k -> itemsAssocToClass);
        }
        if (unmodifiable) {
            return Collections.unmodifiableMap(newItemsAssocToClass);
        }
        return newItemsAssocToClass;
    }

    public static <T, V> Map<T, Set<V>> cloneMapOfSets(Map<T, Set<V>> original, boolean immutable) {
        HashMap<T, HashSet<V>> result = new HashMap<T, HashSet<V>>();
        for (Map.Entry<T, Set<V>> entry : original.entrySet()) {
            T key = entry.getKey();
            Set<V> value = entry.getValue();
            HashSet<V> clonedSet = immutable ? Collections.unmodifiableSet(value) : new HashSet<V>(value);
            result.put(key, clonedSet);
        }
        return immutable ? Collections.unmodifiableMap(result) : result;
    }

    public static <T, U, V> Map<T, Map<U, V>> cloneMapOfMaps(Map<T, Map<U, V>> original, boolean immutable) {
        LinkedHashMap<T, LinkedHashMap<U, V>> result = new LinkedHashMap<T, LinkedHashMap<U, V>>();
        for (Map.Entry<T, Map<U, V>> entry : original.entrySet()) {
            T key = entry.getKey();
            Map<U, V> value = entry.getValue();
            LinkedHashMap<U, V> clonedMap = immutable ? Collections.unmodifiableMap(value) : new LinkedHashMap<U, V>(value);
            result.put(key, clonedMap);
        }
        return immutable ? Collections.unmodifiableMap(result) : result;
    }

    public static <K, V> Map<K, V> mapOf() {
        return Collections.unmodifiableMap(new LinkedHashMap());
    }

    public static <K, V> Map<K, V> mapOf(K k, V v) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k, v);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return Collections.unmodifiableMap(map);
    }
}

