/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.CompactLinkedMap;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.ConverterOptions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class MapConversions {
    static final String V = "_v";
    static final String VALUE = "value";
    static final String DATE = "date";
    static final String TIME = "time";
    static final String ZONE = "zone";
    static final String YEAR = "year";
    static final String YEARS = "years";
    static final String MONTH = "month";
    static final String MONTHS = "months";
    static final String DAY = "day";
    static final String DAYS = "days";
    static final String HOUR = "hour";
    static final String HOURS = "hours";
    static final String MINUTE = "minute";
    static final String MINUTES = "minutes";
    static final String SECOND = "second";
    static final String SECONDS = "seconds";
    static final String EPOCH_MILLIS = "epochMillis";
    static final String MILLI_SECONDS = "millis";
    static final String NANO = "nano";
    static final String NANOS = "nanos";
    static final String OFFSET_HOUR = "offsetHour";
    static final String OFFSET_MINUTE = "offsetMinute";
    static final String MOST_SIG_BITS = "mostSigBits";
    static final String LEAST_SIG_BITS = "leastSigBits";
    static final String OFFSET = "offset";
    private static final String TOTAL_SECONDS = "totalSeconds";
    static final String DATE_TIME = "dateTime";
    private static final String ID = "id";
    public static final String LANGUAGE = "language";
    public static final String VARIANT = "variant";
    public static final String JAR = "jar";
    public static final String AUTHORITY = "authority";
    public static final String REF = "ref";
    public static final String PORT = "port";
    public static final String FILE = "file";
    public static final String HOST = "host";
    public static final String PROTOCOL = "protocol";
    private static String COUNTRY = "country";
    public static final String KEY_VALUE_ERROR_MESSAGE = "To convert from Map to %s the map must include one of the following: %s[_v], or [value] with associated values.";
    private static String[] UUID_PARAMS = new String[]{"mostSigBits", "leastSigBits"};
    private static final String[] TIMESTAMP_PARAMS = new String[]{"time", "nanos"};
    private static final String[] TIMEZONE_PARAMS = new String[]{"zone"};
    private static final String[] CALENDAR_PARAMS = new String[]{"year", "month", "day", "hour", "minute", "second", "millis", "zone"};
    private static final String[] LOCALE_PARAMS = new String[]{"language"};
    private static final String[] LOCAL_DATE_PARAMS = new String[]{"year", "month", "day"};
    private static final String[] LOCAL_TIME_PARAMS = new String[]{"hour", "minute", "second", "nano"};
    private static final String[] OFFSET_TIME_PARAMS = new String[]{"hour", "minute", "second", "nano", "offsetHour", "offsetMinute"};
    private static final String[] OFFSET_DATE_TIME_PARAMS = new String[]{"year", "month", "day", "hour", "minute", "second", "nano", "offsetHour", "offsetMinute"};
    private static final String[] LOCAL_DATE_TIME_PARAMS = new String[]{"date", "time"};
    private static final String[] ZONED_DATE_TIME_PARAMS = new String[]{"zone", "dateTime"};
    private static final String[] DURATION_PARAMS = new String[]{"seconds", "nanos"};
    private static final String[] INSTANT_PARAMS = new String[]{"seconds", "nanos"};
    private static final String[] MONTH_DAY_PARAMS = new String[]{"month", "day"};
    private static final String[] YEAR_MONTH_PARAMS = new String[]{"year", "month"};
    private static final String[] PERIOD_PARAMS = new String[]{"years", "months", "days"};
    private static final String[] ZONE_OFFSET_PARAMS = new String[]{"hours", "minutes", "seconds"};

    private MapConversions() {
    }

    static Object toUUID(Object from, Converter converter) {
        Map map = (Map)from;
        ConverterOptions options = converter.getOptions();
        if (map.containsKey(MOST_SIG_BITS) && map.containsKey(LEAST_SIG_BITS)) {
            long most = converter.convert(map.get(MOST_SIG_BITS), Long.TYPE);
            long least = converter.convert(map.get(LEAST_SIG_BITS), Long.TYPE);
            return new UUID(most, least);
        }
        return MapConversions.fromValueForMultiKey(from, converter, UUID.class, UUID_PARAMS);
    }

    static Byte toByte(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, Byte.class);
    }

    static Short toShort(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, Short.class);
    }

    static Integer toInt(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, Integer.class);
    }

    static Long toLong(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, Long.class);
    }

    static Float toFloat(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, Float.class);
    }

    static Double toDouble(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, Double.class);
    }

    static Boolean toBoolean(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, Boolean.class);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, BigDecimal.class);
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, BigInteger.class);
    }

    static String toString(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, String.class);
    }

    static Character toCharacter(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, Character.TYPE);
    }

    static AtomicInteger toAtomicInteger(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, AtomicInteger.class);
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, AtomicLong.class);
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, AtomicBoolean.class);
    }

    static Date toSqlDate(Object from, Converter converter) {
        return MapConversions.fromSingleKey(from, converter, TIME, Date.class);
    }

    static java.util.Date toDate(Object from, Converter converter) {
        return MapConversions.fromSingleKey(from, converter, EPOCH_MILLIS, java.util.Date.class);
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        Map map = (Map)from;
        ConverterOptions options = converter.getOptions();
        if (map.containsKey(TIME)) {
            long time = converter.convert(map.get(TIME), Long.TYPE);
            int ns = converter.convert(map.get(NANOS), Integer.TYPE);
            Timestamp timeStamp = new Timestamp(time);
            timeStamp.setNanos(ns);
            return timeStamp;
        }
        return MapConversions.fromValueForMultiKey(map, converter, Timestamp.class, TIMESTAMP_PARAMS);
    }

    static TimeZone toTimeZone(Object from, Converter converter) {
        Map map = (Map)from;
        ConverterOptions options = converter.getOptions();
        if (map.containsKey(ZONE)) {
            return converter.convert(map.get(ZONE), TimeZone.class);
        }
        return MapConversions.fromValueForMultiKey(map, converter, TimeZone.class, TIMEZONE_PARAMS);
    }

    static Calendar toCalendar(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(TIME)) {
            TimeZone tz;
            Object zoneRaw = map.get(ZONE);
            if (zoneRaw instanceof String) {
                String zone = (String)zoneRaw;
                tz = TimeZone.getTimeZone(zone);
            } else {
                tz = TimeZone.getTimeZone(converter.getOptions().getZoneId());
            }
            Calendar cal = Calendar.getInstance(tz);
            java.util.Date epochInMillis = converter.convert(map.get(TIME), java.util.Date.class);
            cal.setTimeInMillis(epochInMillis.getTime());
            return cal;
        }
        if (map.containsKey(YEAR)) {
            TimeZone tz;
            int year = converter.convert(map.get(YEAR), Integer.TYPE);
            int month = converter.convert(map.get(MONTH), Integer.TYPE);
            int day = converter.convert(map.get(DAY), Integer.TYPE);
            int hour = converter.convert(map.get(HOUR), Integer.TYPE);
            int minute = converter.convert(map.get(MINUTE), Integer.TYPE);
            int second = converter.convert(map.get(SECOND), Integer.TYPE);
            int ms = converter.convert(map.get(MILLI_SECONDS), Integer.TYPE);
            Object zoneRaw = map.get(ZONE);
            if (zoneRaw instanceof String) {
                String zone = (String)zoneRaw;
                tz = TimeZone.getTimeZone(zone);
            } else {
                tz = TimeZone.getTimeZone(converter.getOptions().getZoneId());
            }
            Calendar cal = Calendar.getInstance(tz);
            cal.set(1, year);
            cal.set(2, month - 1);
            cal.set(5, day);
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, second);
            cal.set(14, ms);
            return cal;
        }
        return MapConversions.fromValueForMultiKey(map, converter, Calendar.class, CALENDAR_PARAMS);
    }

    static Locale toLocale(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(VALUE) || map.containsKey(V)) {
            return MapConversions.fromValueForMultiKey(map, converter, Locale.class, LOCALE_PARAMS);
        }
        String language = converter.convert(map.get(LANGUAGE), String.class);
        if (language == null) {
            throw new IllegalArgumentException("java.util.Locale must specify 'language' field");
        }
        String country = converter.convert(map.get(COUNTRY), String.class);
        String variant = converter.convert(map.get(VARIANT), String.class);
        if (country == null) {
            return new Locale(language);
        }
        if (variant == null) {
            return new Locale(language, country);
        }
        return new Locale(language, country, variant);
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(MONTH) && map.containsKey(DAY) && map.containsKey(YEAR)) {
            ConverterOptions options = converter.getOptions();
            int month = converter.convert(map.get(MONTH), Integer.TYPE);
            int day = converter.convert(map.get(DAY), Integer.TYPE);
            int year = converter.convert(map.get(YEAR), Integer.TYPE);
            return LocalDate.of(year, month, day);
        }
        return MapConversions.fromValueForMultiKey(map, converter, LocalDate.class, LOCAL_DATE_PARAMS);
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(HOUR) && map.containsKey(MINUTE)) {
            ConverterOptions options = converter.getOptions();
            int hour = converter.convert(map.get(HOUR), Integer.TYPE);
            int minute = converter.convert(map.get(MINUTE), Integer.TYPE);
            int second = converter.convert(map.get(SECOND), Integer.TYPE);
            int nano = converter.convert(map.get(NANO), Integer.TYPE);
            return LocalTime.of(hour, minute, second, nano);
        }
        return MapConversions.fromValueForMultiKey(map, converter, LocalTime.class, LOCAL_TIME_PARAMS);
    }

    static OffsetTime toOffsetTime(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(HOUR) && map.containsKey(MINUTE)) {
            ConverterOptions options = converter.getOptions();
            int hour = converter.convert(map.get(HOUR), Integer.TYPE);
            int minute = converter.convert(map.get(MINUTE), Integer.TYPE);
            int second = converter.convert(map.get(SECOND), Integer.TYPE);
            int nano = converter.convert(map.get(NANO), Integer.TYPE);
            int offsetHour = converter.convert(map.get(OFFSET_HOUR), Integer.TYPE);
            int offsetMinute = converter.convert(map.get(OFFSET_MINUTE), Integer.TYPE);
            ZoneOffset zoneOffset = ZoneOffset.ofHoursMinutes(offsetHour, offsetMinute);
            return OffsetTime.of(hour, minute, second, nano, zoneOffset);
        }
        return MapConversions.fromValueForMultiKey(map, converter, OffsetTime.class, OFFSET_TIME_PARAMS);
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        Map map = (Map)from;
        ConverterOptions options = converter.getOptions();
        if (map.containsKey(DATE_TIME) && map.containsKey(OFFSET)) {
            LocalDateTime dateTime = converter.convert(map.get(DATE_TIME), LocalDateTime.class);
            ZoneOffset zoneOffset = converter.convert(map.get(OFFSET), ZoneOffset.class);
            return OffsetDateTime.of(dateTime, zoneOffset);
        }
        if (map.containsKey(YEAR) && map.containsKey(OFFSET_HOUR)) {
            int year = converter.convert(map.get(YEAR), Integer.TYPE);
            int month = converter.convert(map.get(MONTH), Integer.TYPE);
            int day = converter.convert(map.get(DAY), Integer.TYPE);
            int hour = converter.convert(map.get(HOUR), Integer.TYPE);
            int minute = converter.convert(map.get(MINUTE), Integer.TYPE);
            int second = converter.convert(map.get(SECOND), Integer.TYPE);
            int nano = converter.convert(map.get(NANO), Integer.TYPE);
            int offsetHour = converter.convert(map.get(OFFSET_HOUR), Integer.TYPE);
            int offsetMinute = converter.convert(map.get(OFFSET_MINUTE), Integer.TYPE);
            ZoneOffset zoneOffset = ZoneOffset.ofHoursMinutes(offsetHour, offsetMinute);
            return OffsetDateTime.of(year, month, day, hour, minute, second, nano, zoneOffset);
        }
        return MapConversions.fromValueForMultiKey(map, converter, OffsetDateTime.class, OFFSET_DATE_TIME_PARAMS);
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(DATE)) {
            LocalDate localDate = converter.convert(map.get(DATE), LocalDate.class);
            LocalTime localTime = map.containsKey(TIME) ? converter.convert(map.get(TIME), LocalTime.class) : LocalTime.MIDNIGHT;
            return LocalDateTime.of(localDate, localTime);
        }
        return MapConversions.fromValueForMultiKey(from, converter, LocalDateTime.class, LOCAL_DATE_TIME_PARAMS);
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(ZONE) && map.containsKey(DATE_TIME)) {
            ZoneId zoneId = converter.convert(map.get(ZONE), ZoneId.class);
            LocalDateTime localDateTime = converter.convert(map.get(DATE_TIME), LocalDateTime.class);
            return ZonedDateTime.of(localDateTime, zoneId);
        }
        return MapConversions.fromValueForMultiKey(from, converter, ZonedDateTime.class, ZONED_DATE_TIME_PARAMS);
    }

    static Class<?> toClass(Object from, Converter converter) {
        return MapConversions.fromValue(from, converter, Class.class);
    }

    static Duration toDuration(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(SECONDS)) {
            ConverterOptions options = converter.getOptions();
            long sec = converter.convert(map.get(SECONDS), Long.TYPE);
            int nanos = converter.convert(map.get(NANOS), Integer.TYPE);
            return Duration.ofSeconds(sec, nanos);
        }
        return MapConversions.fromValueForMultiKey(from, converter, Duration.class, DURATION_PARAMS);
    }

    static Instant toInstant(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(SECONDS)) {
            ConverterOptions options = converter.getOptions();
            long sec = converter.convert(map.get(SECONDS), Long.TYPE);
            long nanos = converter.convert(map.get(NANOS), Long.TYPE);
            return Instant.ofEpochSecond(sec, nanos);
        }
        return MapConversions.fromValueForMultiKey(from, converter, Instant.class, INSTANT_PARAMS);
    }

    static MonthDay toMonthDay(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(MONTH) && map.containsKey(DAY)) {
            ConverterOptions options = converter.getOptions();
            int month = converter.convert(map.get(MONTH), Integer.TYPE);
            int day = converter.convert(map.get(DAY), Integer.TYPE);
            return MonthDay.of(month, day);
        }
        return MapConversions.fromValueForMultiKey(from, converter, MonthDay.class, MONTH_DAY_PARAMS);
    }

    static YearMonth toYearMonth(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(YEAR) && map.containsKey(MONTH)) {
            ConverterOptions options = converter.getOptions();
            int year = converter.convert(map.get(YEAR), Integer.TYPE);
            int month = converter.convert(map.get(MONTH), Integer.TYPE);
            return YearMonth.of(year, month);
        }
        return MapConversions.fromValueForMultiKey(from, converter, YearMonth.class, YEAR_MONTH_PARAMS);
    }

    static Period toPeriod(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(VALUE) || map.containsKey(V)) {
            return MapConversions.fromValueForMultiKey(from, converter, Period.class, PERIOD_PARAMS);
        }
        Number years = converter.convert(map.getOrDefault(YEARS, 0), Integer.TYPE);
        Number months = converter.convert(map.getOrDefault(MONTHS, 0), Integer.TYPE);
        Number days = converter.convert(map.getOrDefault(DAYS, 0), Integer.TYPE);
        return Period.of(years.intValue(), months.intValue(), days.intValue());
    }

    static ZoneId toZoneId(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(ZONE)) {
            ConverterOptions options = converter.getOptions();
            ZoneId zoneId = converter.convert(map.get(ZONE), ZoneId.class);
            return zoneId;
        }
        if (map.containsKey(ID)) {
            ConverterOptions options = converter.getOptions();
            ZoneId zoneId = converter.convert(map.get(ID), ZoneId.class);
            return zoneId;
        }
        return MapConversions.fromSingleKey(from, converter, ZONE, ZoneId.class);
    }

    static ZoneOffset toZoneOffset(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(HOURS)) {
            int hours = converter.convert(map.get(HOURS), Integer.TYPE);
            int minutes = converter.convert(map.getOrDefault(MINUTES, 0), Integer.TYPE);
            int seconds = converter.convert(map.getOrDefault(SECONDS, 0), Integer.TYPE);
            return ZoneOffset.ofHoursMinutesSeconds(hours, minutes, seconds);
        }
        return MapConversions.fromValueForMultiKey(from, converter, ZoneOffset.class, ZONE_OFFSET_PARAMS);
    }

    static Year toYear(Object from, Converter converter) {
        return MapConversions.fromSingleKey(from, converter, YEAR, Year.class);
    }

    static URL toURL(Object from, Converter converter) {
        Map map = (Map)from;
        StringBuilder builder = new StringBuilder(20);
        try {
            if (map.containsKey(VALUE) || map.containsKey(V)) {
                return MapConversions.fromValue(map, converter, URL.class);
            }
            String protocol = (String)map.get(PROTOCOL);
            String host = (String)map.get(HOST);
            String file = (String)map.get(FILE);
            String authority = (String)map.get(AUTHORITY);
            String ref = (String)map.get(REF);
            Long port = (Long)map.get(PORT);
            builder.append(protocol);
            builder.append(':');
            if (!protocol.equalsIgnoreCase(JAR)) {
                builder.append("//");
            }
            if (authority != null && !authority.isEmpty()) {
                builder.append(authority);
            } else {
                if (host != null && !host.isEmpty()) {
                    builder.append(host);
                }
                if (!port.equals(-1L)) {
                    builder.append(":" + port);
                }
            }
            if (file != null && !file.isEmpty()) {
                builder.append(file);
            }
            if (ref != null && !ref.isEmpty()) {
                builder.append("#" + ref);
            }
            return URI.create(builder.toString()).toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot convert Map to URL.  Malformed URL:  '" + builder + "'");
        }
    }

    static URI toURI(Object from, Converter converter) {
        Map<?, ?> map = MapConversions.asMap(from);
        return MapConversions.fromValue(map, converter, URI.class);
    }

    static Map<String, ?> initMap(Object from, Converter converter) {
        CompactLinkedMap<String, Object> map = new CompactLinkedMap<String, Object>();
        map.put(V, from);
        return map;
    }

    private static <T> T fromSingleKey(Object from, Converter converter, String key, Class<T> type) {
        MapConversions.validateParams(converter, type);
        Map<?, ?> map = MapConversions.asMap(from);
        if (map.containsKey(key)) {
            return converter.convert(map.get(key), type);
        }
        return MapConversions.extractValue(map, converter, type, key);
    }

    private static <T> T fromValueForMultiKey(Object from, Converter converter, Class<T> type, String[] keys) {
        MapConversions.validateParams(converter, type);
        return MapConversions.extractValue(MapConversions.asMap(from), converter, type, keys);
    }

    private static <T> T fromValue(Object from, Converter converter, Class<T> type) {
        MapConversions.validateParams(converter, type);
        return MapConversions.extractValue(MapConversions.asMap(from), converter, type, new String[0]);
    }

    private static <T> T extractValue(Map<?, ?> map, Converter converter, Class<T> type, String ... keys) {
        if (map.containsKey(V)) {
            return converter.convert(map.get(V), type);
        }
        if (map.containsKey(VALUE)) {
            return converter.convert(map.get(VALUE), type);
        }
        String keyText = ArrayUtilities.isEmpty(keys) ? "" : "[" + String.join((CharSequence)", ", keys) + "], ";
        throw new IllegalArgumentException(String.format(KEY_VALUE_ERROR_MESSAGE, Converter.getShortName(type), keyText));
    }

    private static <T> void validateParams(Converter converter, Class<T> type) {
        Convention.throwIfNull(type, "type cannot be null");
        Convention.throwIfNull(converter, "converter cannot be null");
    }

    private static Map<?, ?> asMap(Object o) {
        Convention.throwIfFalse(o instanceof Map, "from must be an instance of map");
        return (Map)o;
    }

    static Map<?, ?> toMap(Object from, Converter converter) {
        Map source = (Map)from;
        LinkedHashMap copy = new LinkedHashMap(source);
        return copy;
    }
}

