/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;

public class Traverser {
    private final Map<Object, Object> _objVisited = new IdentityHashMap<Object, Object>();
    protected final Map<Class, ClassInfo> _classCache = new HashMap<Class, ClassInfo>();

    public static void traverse(Object o, Visitor visitor) {
        Traverser.traverse(o, null, visitor);
    }

    public static void traverse(Object o, Class<?>[] skip, Visitor visitor) {
        Traverser traverse = new Traverser();
        traverse.walk(o, skip, visitor);
        traverse._objVisited.clear();
        traverse._classCache.clear();
    }

    public void walk(Object root, Class<?>[] skip, Visitor visitor) {
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Class<?> clazz;
            ClassInfo classInfo;
            Object current = stack.removeFirst();
            if (current == null || this._objVisited.containsKey(current) || (classInfo = this.getClassInfo(clazz = current.getClass(), skip))._skip) continue;
            this._objVisited.put(current, null);
            visitor.process(current);
            if (clazz.isArray()) {
                ClassInfo info;
                int len = Array.getLength(current);
                Class<?> compType = clazz.getComponentType();
                if (compType.isPrimitive() || (info = this.getClassInfo(compType, skip))._skip) continue;
                for (int i = 0; i < len; ++i) {
                    Object element = Array.get(current, i);
                    if (element == null) continue;
                    stack.add(Array.get(current, i));
                }
                continue;
            }
            if (current instanceof Collection) {
                Traverser.walkCollection(stack, (Collection)current);
                continue;
            }
            if (current instanceof Map) {
                Traverser.walkMap(stack, (Map)current);
                continue;
            }
            this.walkFields(stack, current, skip);
        }
    }

    private void walkFields(Deque stack, Object current, Class<?>[] skip) {
        ClassInfo classInfo = this.getClassInfo(current.getClass(), skip);
        for (Field field : classInfo._refFields) {
            try {
                Object value = field.get(current);
                if (value == null || value.getClass().isPrimitive()) continue;
                stack.add(value);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private static void walkCollection(Deque stack, Collection<?> col) {
        for (Object o : col) {
            if (o == null || o.getClass().isPrimitive()) continue;
            stack.add(o);
        }
    }

    private static void walkMap(Deque stack, Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object o = entry.getKey();
            if (o == null || o.getClass().isPrimitive()) continue;
            stack.add(entry.getKey());
            stack.add(entry.getValue());
        }
    }

    private ClassInfo getClassInfo(Class<?> current, Class<?>[] skip) {
        ClassInfo classCache = this._classCache.get(current);
        if (classCache != null) {
            return classCache;
        }
        classCache = new ClassInfo(current, skip);
        this._classCache.put(current, classCache);
        return classCache;
    }

    public static class ClassInfo {
        private boolean _skip = false;
        private final Collection<Field> _refFields = new ArrayList<Field>();

        public ClassInfo(Class<?> c, Class<?>[] skip) {
            if (skip != null) {
                for (Class<?> klass : skip) {
                    if (!klass.isAssignableFrom(c)) continue;
                    this._skip = true;
                    return;
                }
            }
            Collection<Field> fields = ReflectionUtils.getDeepDeclaredFields(c);
            for (Field field : fields) {
                Class<?> fc = field.getType();
                if (fc.isPrimitive()) continue;
                this._refFields.add(field);
            }
        }
    }

    public static interface Visitor {
        public void process(Object var1);
    }
}

