/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CompactLinkedMap;
import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.InstantConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

final class OffsetDateTimeConversions {
    private OffsetDateTimeConversions() {
    }

    static Instant toInstant(Object from, Converter converter) {
        return ((OffsetDateTime)from).toInstant();
    }

    static long toLong(Object from, Converter converter) {
        return OffsetDateTimeConversions.toInstant(from, converter).toEpochMilli();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return OffsetDateTimeConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return OffsetDateTimeConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        return OffsetDateTimeConversions.toZonedDateTime(from, converter).toLocalTime();
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(OffsetDateTimeConversions.toLong(from, converter));
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        OffsetDateTime odt = (OffsetDateTime)from;
        return Timestamp.from(odt.toInstant());
    }

    static Calendar toCalendar(Object from, Converter converter) {
        Calendar calendar = Calendar.getInstance(converter.getOptions().getTimeZone());
        calendar.setTimeInMillis(OffsetDateTimeConversions.toLong(from, converter));
        return calendar;
    }

    static java.sql.Date toSqlDate(Object from, Converter converter) {
        return new java.sql.Date(OffsetDateTimeConversions.toLong(from, converter));
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return ((OffsetDateTime)from).toInstant().atZone(converter.getOptions().getZoneId());
    }

    static Date toDate(Object from, Converter converter) {
        return new Date(OffsetDateTimeConversions.toLong(from, converter));
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Instant instant = OffsetDateTimeConversions.toInstant(from, converter);
        return InstantConversions.toBigInteger(instant, converter);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        OffsetDateTime offsetDateTime = (OffsetDateTime)from;
        Instant instant = offsetDateTime.toInstant();
        return InstantConversions.toBigDecimal(instant, converter);
    }

    static OffsetTime toOffsetTime(Object from, Converter converter) {
        OffsetDateTime dateTime = (OffsetDateTime)from;
        return dateTime.toOffsetTime();
    }

    static String toString(Object from, Converter converter) {
        OffsetDateTime offsetDateTime = (OffsetDateTime)from;
        return offsetDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        ZonedDateTime zdt = OffsetDateTimeConversions.toZonedDateTime(from, converter);
        CompactLinkedMap<String, Object> target = new CompactLinkedMap<String, Object>();
        target.put("date", zdt.toLocalDate().toString());
        target.put("time", zdt.toLocalTime().toString());
        target.put("offset", zdt.getOffset().toString());
        return target;
    }

    static double toDouble(Object from, Converter converter) {
        OffsetDateTime odt = (OffsetDateTime)from;
        Instant instant = odt.toInstant();
        return BigDecimalConversions.secondsAndNanosToDouble(instant.getEpochSecond(), instant.getNano()).doubleValue();
    }
}

