/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.CollectionUtilities;
import com.cedarsoftware.util.CompactLinkedMap;
import com.cedarsoftware.util.DateUtilities;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class MapConversions {
    static final String V = "_v";
    static final String VALUE = "value";
    static final String DATE = "date";
    static final String TIME = "time";
    static final String ZONE = "zone";
    static final String YEAR = "year";
    static final String YEARS = "years";
    static final String MONTH = "month";
    static final String MONTHS = "months";
    static final String DAY = "day";
    static final String DAYS = "days";
    static final String HOUR = "hour";
    static final String HOURS = "hours";
    static final String MINUTE = "minute";
    static final String MINUTES = "minutes";
    static final String SECOND = "second";
    static final String SECONDS = "seconds";
    static final String EPOCH_MILLIS = "epochMillis";
    static final String NANOS = "nanos";
    static final String MOST_SIG_BITS = "mostSigBits";
    static final String LEAST_SIG_BITS = "leastSigBits";
    static final String OFFSET = "offset";
    static final String OFFSET_HOUR = "offsetHour";
    static final String OFFSET_MINUTE = "offsetMinute";
    static final String ID = "id";
    static final String LANGUAGE = "language";
    static final String COUNTRY = "country";
    static final String SCRIPT = "script";
    static final String VARIANT = "variant";
    static final String URI_KEY = "URI";
    static final String URL_KEY = "URL";
    static final String UUID = "UUID";
    static final String CLASS = "class";
    static final String MESSAGE = "message";
    static final String DETAIL_MESSAGE = "detailMessage";
    static final String CAUSE = "cause";
    static final String CAUSE_MESSAGE = "causeMessage";
    static final String OPTIONAL = " (optional)";

    private MapConversions() {
    }

    static Object toUUID(Object from, Converter converter) {
        Map map = (Map)from;
        Object uuid = map.get(UUID);
        if (uuid != null) {
            return converter.convert(uuid, UUID.class);
        }
        Object mostSigBits = map.get(MOST_SIG_BITS);
        Object leastSigBits = map.get(LEAST_SIG_BITS);
        if (mostSigBits != null && leastSigBits != null) {
            long most = converter.convert(mostSigBits, Long.TYPE);
            long least = converter.convert(leastSigBits, Long.TYPE);
            return new UUID(most, least);
        }
        return MapConversions.fromMap(from, converter, UUID.class, {UUID}, {MOST_SIG_BITS, LEAST_SIG_BITS});
    }

    static Byte toByte(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, Byte.class, new String[0][]);
    }

    static Short toShort(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, Short.class, new String[0][]);
    }

    static Integer toInt(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, Integer.class, new String[0][]);
    }

    static Long toLong(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, Long.class, new String[0][]);
    }

    static Float toFloat(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, Float.class, new String[0][]);
    }

    static Double toDouble(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, Double.class, new String[0][]);
    }

    static Boolean toBoolean(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, Boolean.class, new String[0][]);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, BigDecimal.class, new String[0][]);
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, BigInteger.class, new String[0][]);
    }

    static String toString(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, String.class, new String[0][]);
    }

    static StringBuffer toStringBuffer(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, StringBuffer.class, new String[0][]);
    }

    static StringBuilder toStringBuilder(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, StringBuilder.class, new String[0][]);
    }

    static Character toCharacter(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, Character.TYPE, new String[0][]);
    }

    static AtomicInteger toAtomicInteger(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, AtomicInteger.class, new String[0][]);
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, AtomicLong.class, new String[0][]);
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, AtomicBoolean.class, new String[0][]);
    }

    static Date toSqlDate(Object from, Converter converter) {
        Map.Entry<Long, Integer> epochTime = MapConversions.toEpochMillis(from, converter);
        if (epochTime == null) {
            return MapConversions.fromMap(from, converter, Date.class, {EPOCH_MILLIS}, {TIME, "zone (optional)"}, {DATE, TIME, "zone (optional)"});
        }
        return new Date(epochTime.getKey() + (long)(epochTime.getValue() / 1000000));
    }

    static java.util.Date toDate(Object from, Converter converter) {
        Map.Entry<Long, Integer> epochTime = MapConversions.toEpochMillis(from, converter);
        if (epochTime == null) {
            return MapConversions.fromMap(from, converter, java.util.Date.class, {EPOCH_MILLIS}, {TIME, "zone (optional)"}, {DATE, TIME, "zone (optional)"});
        }
        return new java.util.Date(epochTime.getKey() + (long)(epochTime.getValue() / 1000000));
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        Map map = (Map)from;
        Object epochMillis = map.get(EPOCH_MILLIS);
        int ns = converter.convert(map.get(NANOS), Integer.TYPE);
        if (epochMillis != null) {
            long time = converter.convert(epochMillis, Long.TYPE);
            Timestamp timeStamp = new Timestamp(time);
            if (map.containsKey(NANOS) && ns != 0) {
                timeStamp.setNanos(ns);
            }
            return timeStamp;
        }
        Map.Entry<Long, Integer> epochTime = MapConversions.toEpochMillis(from, converter);
        if (epochTime == null) {
            return MapConversions.fromMap(from, converter, Timestamp.class, {EPOCH_MILLIS, "nanos (optional)"}, {TIME, "zone (optional)"}, {DATE, TIME, "zone (optional)"});
        }
        Timestamp timestamp = new Timestamp(epochTime.getKey());
        timestamp.setNanos(epochTime.getValue());
        return timestamp;
    }

    static TimeZone toTimeZone(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, TimeZone.class, new String[][]{{ZONE}});
    }

    static Calendar toCalendar(Object from, Converter converter) {
        Map map = (Map)from;
        Object epochMillis = map.get(EPOCH_MILLIS);
        if (epochMillis != null) {
            return converter.convert(epochMillis, Calendar.class);
        }
        Object date = map.get(DATE);
        Object time = map.get(TIME);
        Object zone = map.get(ZONE);
        ZoneId zoneId = zone != null ? converter.convert(zone, ZoneId.class) : converter.getOptions().getZoneId();
        if (date != null && time != null) {
            LocalDate localDate = converter.convert(date, LocalDate.class);
            LocalTime localTime = converter.convert(time, LocalTime.class);
            LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
            ZonedDateTime zdt = ldt.atZone(zoneId);
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(zoneId));
            cal.set(1, zdt.getYear());
            cal.set(2, zdt.getMonthValue() - 1);
            cal.set(5, zdt.getDayOfMonth());
            cal.set(11, zdt.getHour());
            cal.set(12, zdt.getMinute());
            cal.set(13, zdt.getSecond());
            cal.set(14, zdt.getNano() / 1000000);
            cal.getTime();
            return cal;
        }
        if (time != null && date == null) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(zoneId));
            ZonedDateTime zdt = DateUtilities.parseDate((String)time, zoneId, true);
            cal.setTimeInMillis(zdt.toInstant().toEpochMilli());
            return cal;
        }
        return MapConversions.fromMap(from, converter, Calendar.class, {EPOCH_MILLIS}, {TIME, "zone (optional)"}, {DATE, TIME, "zone (optional)"});
    }

    private static Map.Entry<Long, Integer> toEpochMillis(Object from, Converter converter) {
        Map map = (Map)from;
        Object epochMillis = map.get(EPOCH_MILLIS);
        int ns = converter.convert(map.get(NANOS), Integer.TYPE);
        if (epochMillis != null) {
            return new AbstractMap.SimpleImmutableEntry<Long, Integer>(converter.convert(epochMillis, Long.TYPE), ns);
        }
        Object time = map.get(TIME);
        Object date = map.get(DATE);
        Object zone = map.get(ZONE);
        if (time != null && date != null && zone != null) {
            LocalDate ld = converter.convert(date, LocalDate.class);
            LocalTime lt = converter.convert(time, LocalTime.class);
            ZoneId zoneId = converter.convert(zone, ZoneId.class);
            ZonedDateTime zdt = ZonedDateTime.of(ld, lt, zoneId);
            return MapConversions.nanoRule(zdt, ns);
        }
        if (time != null && date == null && zone == null) {
            ZonedDateTime zdt = converter.convert(time, ZonedDateTime.class);
            return MapConversions.nanoRule(zdt, ns);
        }
        if (time != null && date == null && zone != null) {
            LocalDateTime ldt = converter.convert(time, LocalDateTime.class);
            ZoneId zoneId = converter.convert(zone, ZoneId.class);
            ZonedDateTime zdt = ZonedDateTime.of(ldt, zoneId);
            return MapConversions.nanoRule(zdt, ns);
        }
        if (time != null && date != null && zone == null) {
            LocalDate ld = converter.convert(date, LocalDate.class);
            LocalTime lt = converter.convert(time, LocalTime.class);
            ZonedDateTime zdt = ZonedDateTime.of(ld, lt, converter.getOptions().getZoneId());
            return MapConversions.nanoRule(zdt, ns);
        }
        return null;
    }

    private static Map.Entry<Long, Integer> nanoRule(ZonedDateTime zdt, int nanosFromMap) {
        int nanos = zdt.getNano();
        if (nanos != 0) {
            nanosFromMap = nanos;
        }
        return new AbstractMap.SimpleImmutableEntry<Long, Integer>(zdt.toEpochSecond() * 1000L, nanosFromMap);
    }

    static Locale toLocale(Object from, Converter converter) {
        Map map = (Map)from;
        String language = converter.convert(map.get(LANGUAGE), String.class);
        if (StringUtilities.isEmpty(language)) {
            return MapConversions.fromMap(from, converter, Locale.class, new String[][]{{LANGUAGE, "country (optional)", "script (optional)", "variant (optional)"}});
        }
        String country = converter.convert(map.get(COUNTRY), String.class);
        String script = converter.convert(map.get(SCRIPT), String.class);
        String variant = converter.convert(map.get(VARIANT), String.class);
        Locale.Builder builder = new Locale.Builder();
        try {
            builder.setLanguage(language);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Locale language '" + language + "' invalid.", e);
        }
        if (StringUtilities.hasContent(country)) {
            try {
                builder.setRegion(country);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Locale region '" + country + "' invalid.", e);
            }
        }
        if (StringUtilities.hasContent(script)) {
            try {
                builder.setScript(script);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Locale script '" + script + "' invalid.", e);
            }
        }
        if (StringUtilities.hasContent(variant)) {
            try {
                builder.setVariant(variant);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Locale variant '" + variant + "' invalid.", e);
            }
        }
        return builder.build();
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        Map map = (Map)from;
        Object year = map.get(YEAR);
        Object month = map.get(MONTH);
        Object day = map.get(DAY);
        if (year != null && month != null && day != null) {
            int y = converter.convert(year, Integer.TYPE);
            int m = converter.convert(month, Integer.TYPE);
            int d = converter.convert(day, Integer.TYPE);
            return LocalDate.of(y, m, d);
        }
        return MapConversions.fromMap(from, converter, LocalDate.class, {DATE}, {YEAR, MONTH, DAY});
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        Map map = (Map)from;
        Object hour = map.get(HOUR);
        Object minute = map.get(MINUTE);
        Object second = map.get(SECOND);
        Object nano = map.get(NANOS);
        if (hour != null && minute != null) {
            int h = converter.convert(hour, Integer.TYPE);
            int m = converter.convert(minute, Integer.TYPE);
            int s = converter.convert(second, Integer.TYPE);
            int n = converter.convert(nano, Integer.TYPE);
            return LocalTime.of(h, m, s, n);
        }
        return MapConversions.fromMap(from, converter, LocalTime.class, {TIME}, {HOUR, MINUTE, "second (optional)", "nanos (optional)"});
    }

    static OffsetTime toOffsetTime(Object from, Converter converter) {
        Object time;
        Map map = (Map)from;
        Object hour = map.get(HOUR);
        Object minute = map.get(MINUTE);
        Object second = map.get(SECOND);
        Object nano = map.get(NANOS);
        Object oh = map.get(OFFSET_HOUR);
        Object om = map.get(OFFSET_MINUTE);
        if (hour != null && minute != null) {
            int h = converter.convert(hour, Integer.TYPE);
            int m = converter.convert(minute, Integer.TYPE);
            int s = converter.convert(second, Integer.TYPE);
            int n = converter.convert(nano, Integer.TYPE);
            if (oh != null && om != null) {
                ZoneOffset zoneOffset;
                int offsetHour = converter.convert(oh, Integer.TYPE);
                int offsetMinute = converter.convert(om, Integer.TYPE);
                try {
                    zoneOffset = ZoneOffset.ofHoursMinutes(offsetHour, offsetMinute);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Offset 'hour' and 'minute' are not correct", e);
                }
                return OffsetTime.of(h, m, s, n, zoneOffset);
            }
        }
        if ((time = map.get(TIME)) != null) {
            return converter.convert(time, OffsetTime.class);
        }
        return MapConversions.fromMap(from, converter, OffsetTime.class, {TIME}, {HOUR, MINUTE, "second (optional)", "nanos (optional)", OFFSET_HOUR, OFFSET_MINUTE});
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        Map map = (Map)from;
        Object offset = map.get(OFFSET);
        Object time = map.get(TIME);
        Object date = map.get(DATE);
        if (time != null && offset != null && date == null) {
            LocalDateTime ldt = converter.convert(time, LocalDateTime.class);
            ZoneOffset zoneOffset = converter.convert(offset, ZoneOffset.class);
            return OffsetDateTime.of(ldt, zoneOffset);
        }
        if (time != null && offset != null && date != null) {
            LocalDate ld = converter.convert(date, LocalDate.class);
            LocalTime lt = converter.convert(time, LocalTime.class);
            ZoneOffset zoneOffset = converter.convert(offset, ZoneOffset.class);
            return OffsetDateTime.of(ld, lt, zoneOffset);
        }
        return MapConversions.fromMap(from, converter, OffsetDateTime.class, {TIME, OFFSET}, {DATE, TIME, OFFSET});
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        Map map = (Map)from;
        Object date = map.get(DATE);
        if (date != null) {
            LocalDate localDate = converter.convert(date, LocalDate.class);
            Object time = map.get(TIME);
            LocalTime localTime = time != null ? converter.convert(time, LocalTime.class) : LocalTime.MIDNIGHT;
            return LocalDateTime.of(localDate, localTime);
        }
        return MapConversions.fromMap(from, converter, LocalDateTime.class, new String[][]{{DATE, "time (optional)"}});
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        Map map = (Map)from;
        Object epochMillis = map.get(EPOCH_MILLIS);
        if (epochMillis != null) {
            return converter.convert(epochMillis, ZonedDateTime.class);
        }
        Object date = map.get(DATE);
        Object time = map.get(TIME);
        Object zone = map.get(ZONE);
        if (date != null && time != null && zone != null) {
            LocalDate localDate = converter.convert(date, LocalDate.class);
            LocalTime localTime = converter.convert(time, LocalTime.class);
            ZoneId zoneId = converter.convert(zone, ZoneId.class);
            return ZonedDateTime.of(localDate, localTime, zoneId);
        }
        if (zone != null && time != null && date == null) {
            ZoneId zoneId = converter.convert(zone, ZoneId.class);
            LocalDateTime localDateTime = converter.convert(time, LocalDateTime.class);
            return ZonedDateTime.of(localDateTime, zoneId);
        }
        return MapConversions.fromMap(from, converter, ZonedDateTime.class, {EPOCH_MILLIS}, {TIME, ZONE}, {DATE, TIME, ZONE});
    }

    static Class<?> toClass(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, Class.class, new String[0][]);
    }

    static Duration toDuration(Object from, Converter converter) {
        Map map = (Map)from;
        Object seconds = map.get(SECONDS);
        if (seconds != null) {
            long sec = converter.convert(seconds, Long.TYPE);
            int nanos = converter.convert(map.get(NANOS), Integer.TYPE);
            return Duration.ofSeconds(sec, nanos);
        }
        return MapConversions.fromMap(from, converter, Duration.class, new String[][]{{SECONDS, "nanos (optional)"}});
    }

    static Instant toInstant(Object from, Converter converter) {
        Map map = (Map)from;
        Object seconds = map.get(SECONDS);
        if (seconds != null) {
            long sec = converter.convert(seconds, Long.TYPE);
            long nanos = converter.convert(map.get(NANOS), Long.TYPE);
            return Instant.ofEpochSecond(sec, nanos);
        }
        return MapConversions.fromMap(from, converter, Instant.class, new String[][]{{SECONDS, "nanos (optional)"}});
    }

    static MonthDay toMonthDay(Object from, Converter converter) {
        Map map = (Map)from;
        Object month = map.get(MONTH);
        Object day = map.get(DAY);
        if (month != null && day != null) {
            int m = converter.convert(month, Integer.TYPE);
            int d = converter.convert(day, Integer.TYPE);
            return MonthDay.of(m, d);
        }
        return MapConversions.fromMap(from, converter, MonthDay.class, new String[][]{{MONTH, DAY}});
    }

    static YearMonth toYearMonth(Object from, Converter converter) {
        Map map = (Map)from;
        Object year = map.get(YEAR);
        Object month = map.get(MONTH);
        if (year != null && month != null) {
            int y = converter.convert(year, Integer.TYPE);
            int m = converter.convert(month, Integer.TYPE);
            return YearMonth.of(y, m);
        }
        return MapConversions.fromMap(from, converter, YearMonth.class, new String[][]{{YEAR, MONTH}});
    }

    static Period toPeriod(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(VALUE) || map.containsKey(V)) {
            return MapConversions.fromMap(from, converter, Period.class, new String[][]{{YEARS, MONTHS, DAYS}});
        }
        Number years = converter.convert(map.getOrDefault(YEARS, 0), Integer.TYPE);
        Number months = converter.convert(map.getOrDefault(MONTHS, 0), Integer.TYPE);
        Number days = converter.convert(map.getOrDefault(DAYS, 0), Integer.TYPE);
        return Period.of(years.intValue(), months.intValue(), days.intValue());
    }

    static ZoneId toZoneId(Object from, Converter converter) {
        Map map = (Map)from;
        Object zone = map.get(ZONE);
        if (zone != null) {
            return converter.convert(zone, ZoneId.class);
        }
        Object id = map.get(ID);
        if (id != null) {
            return converter.convert(id, ZoneId.class);
        }
        return MapConversions.fromMap(from, converter, ZoneId.class, {ZONE}, {ID});
    }

    static ZoneOffset toZoneOffset(Object from, Converter converter) {
        Map map = (Map)from;
        if (map.containsKey(HOURS)) {
            int hours = converter.convert(map.get(HOURS), Integer.TYPE);
            int minutes = converter.convert(map.getOrDefault(MINUTES, 0), Integer.TYPE);
            int seconds = converter.convert(map.getOrDefault(SECONDS, 0), Integer.TYPE);
            return ZoneOffset.ofHoursMinutesSeconds(hours, minutes, seconds);
        }
        return MapConversions.fromMap(from, converter, ZoneOffset.class, new String[][]{{HOURS, "minutes (optional)", "seconds (optional)"}});
    }

    static Year toYear(Object from, Converter converter) {
        return MapConversions.fromMap(from, converter, Year.class, new String[][]{{YEAR}});
    }

    static URL toURL(Object from, Converter converter) {
        Map map = (Map)from;
        String url = (String)map.get(URL_KEY);
        if (StringUtilities.hasContent(url)) {
            return converter.convert(url, URL.class);
        }
        return MapConversions.fromMap(from, converter, URL.class, new String[][]{{URL_KEY}});
    }

    static Throwable toThrowable(Object from, Converter converter, Class<?> target) {
        Map map = (Map)from;
        try {
            Class<?> causeClass;
            Class<?> mapClass;
            Class<?> classToUse = target;
            String className = (String)map.get(CLASS);
            if (StringUtilities.hasContent(className) && (mapClass = ClassUtilities.forName(className, ClassUtilities.getClassLoader(MapConversions.class))) != null && ClassUtilities.computeInheritanceDistance(mapClass, target) >= 0) {
                classToUse = mapClass;
            }
            Throwable cause = null;
            String causeClassName = (String)map.get(CAUSE);
            String causeMessage = (String)map.get(CAUSE_MESSAGE);
            if (StringUtilities.hasContent(causeClassName) && (causeClass = ClassUtilities.forName(causeClassName, ClassUtilities.getClassLoader(MapConversions.class))) != null) {
                cause = (Throwable)ClassUtilities.newInstance(converter, causeClass, Arrays.asList(causeMessage));
            }
            ArrayList<Object> constructorArgs = new ArrayList<Object>();
            String message = (String)map.get(MESSAGE);
            if (message != null) {
                constructorArgs.add(message);
            } else if (map.containsKey(DETAIL_MESSAGE)) {
                constructorArgs.add(map.get(DETAIL_MESSAGE));
            }
            if (cause != null) {
                constructorArgs.add(cause);
            }
            Throwable exception = (Throwable)ClassUtilities.newInstance(converter, classToUse, constructorArgs);
            if (cause != null && exception.getCause() == null) {
                exception.initCause(cause);
            }
            MapConversions.populateFields(exception, map, converter);
            exception.setStackTrace(new StackTraceElement[0]);
            return exception;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to reconstruct exception instance from map: " + map, e);
        }
    }

    private static void populateFields(Throwable exception, Map<String, Object> map, Converter converter) {
        Set<String> skipFields = CollectionUtilities.setOf(CAUSE, CAUSE_MESSAGE, MESSAGE, "stackTrace");
        Map<String, Field> fieldMap = ReflectionUtils.getAllDeclaredFieldsMap(exception.getClass(), field -> !skipFields.contains(field.getName()));
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String fieldName = entry.getKey();
            Object value = entry.getValue();
            Field field2 = fieldMap.get(fieldName);
            if (field2 == null) continue;
            try {
                Object convertedValue = value;
                if (value != null && !field2.getType().isAssignableFrom(value.getClass())) {
                    convertedValue = converter.convert(value, field2.getType());
                }
                field2.set(exception, convertedValue);
            }
            catch (Exception exception2) {}
        }
    }

    static URI toURI(Object from, Converter converter) {
        Map map = (Map)from;
        String uri = (String)map.get(URI_KEY);
        if (StringUtilities.hasContent(uri)) {
            return converter.convert(map.get(URI_KEY), URI.class);
        }
        return MapConversions.fromMap(from, converter, URI.class, new String[][]{{URI_KEY}});
    }

    static Map<String, ?> initMap(Object from, Converter converter) {
        CompactLinkedMap<String, Object> map = new CompactLinkedMap<String, Object>();
        map.put(V, from);
        return map;
    }

    private static <T> T fromMap(Object from, Converter converter, Class<T> type, String[] ... keySets) {
        Map map = (Map)from;
        for (String[] keys : keySets) {
            String string;
            if (keys.length != 1 || !map.containsKey(string = keys[0])) continue;
            return converter.convert(map.get(string), type);
        }
        if (map.containsKey(V)) {
            return converter.convert(map.get(V), type);
        }
        if (map.containsKey(VALUE)) {
            return converter.convert(map.get(VALUE), type);
        }
        StringBuilder builder = new StringBuilder("To convert from Map to '" + Converter.getShortName(type) + "' the map must include: ");
        for (CharSequence[] charSequenceArray : keySets) {
            builder.append("[");
            builder.append(String.join((CharSequence)", ", charSequenceArray));
            builder.append("]");
            builder.append(", ");
        }
        builder.append("[value]");
        if (keySets.length > 0) {
            builder.append(",");
        }
        builder.append(" or [_v] as keys with associated values.");
        throw new IllegalArgumentException(builder.toString());
    }
}

