/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.convert.CollectionsWrappers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;

public class CollectionUtilities {
    private static final Set<?> unmodifiableEmptySet = Collections.unmodifiableSet(new HashSet());
    private static final List<?> unmodifiableEmptyList = Collections.unmodifiableList(new ArrayList());
    private static final Class<?> unmodifiableCollectionClass = CollectionsWrappers.getUnmodifiableCollectionClass();
    private static final Class<?> synchronizedCollectionClass = CollectionsWrappers.getSynchronizedCollectionClass();

    private CollectionUtilities() {
    }

    public static boolean isEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }

    public static boolean hasContent(Collection<?> col) {
        return col != null && !col.isEmpty();
    }

    public static int size(Collection<?> col) {
        return col == null ? 0 : col.size();
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... items) {
        if (items == null || items.length == 0) {
            return unmodifiableEmptyList;
        }
        ArrayList list = new ArrayList();
        Collections.addAll(list, items);
        return Collections.unmodifiableList(list);
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... items) {
        if (items == null || items.length == 0) {
            return unmodifiableEmptySet;
        }
        LinkedHashSet set = new LinkedHashSet();
        Collections.addAll(set, items);
        return Collections.unmodifiableSet(set);
    }

    public static boolean isUnmodifiable(Class<?> targetType) {
        Objects.requireNonNull(targetType, "targetType (Class) cannot be null");
        return unmodifiableCollectionClass.isAssignableFrom(targetType);
    }

    public static boolean isSynchronized(Class<?> targetType) {
        Objects.requireNonNull(targetType, "targetType (Class) cannot be null");
        return synchronizedCollectionClass.isAssignableFrom(targetType);
    }

    public static <T> Collection<T> getUnmodifiableCollection(Collection<T> collection) {
        Objects.requireNonNull(collection, "Collection must not be null");
        if (collection instanceof NavigableSet) {
            return Collections.unmodifiableNavigableSet((NavigableSet)collection);
        }
        if (collection instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)collection);
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        return Collections.unmodifiableCollection(collection);
    }

    public static <T> Collection<T> getEmptyCollection(Collection<T> collection) {
        Objects.requireNonNull(collection, "Collection must not be null");
        if (collection instanceof NavigableSet) {
            return Collections.emptyNavigableSet();
        }
        if (collection instanceof SortedSet) {
            return Collections.emptySortedSet();
        }
        if (collection instanceof Set) {
            return Collections.emptySet();
        }
        if (collection instanceof List) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public static <T extends Collection<?>, E> Collection<E> getCheckedCollection(T collection, Class<E> type) {
        Objects.requireNonNull(collection, "Collection must not be null");
        Objects.requireNonNull(type, "Type (Class) must not be null");
        if (collection instanceof NavigableSet) {
            return Collections.checkedNavigableSet((NavigableSet)collection, type);
        }
        if (collection instanceof SortedSet) {
            return Collections.checkedSortedSet((SortedSet)collection, type);
        }
        if (collection instanceof Set) {
            return Collections.checkedSet((Set)collection, type);
        }
        if (collection instanceof List) {
            return Collections.checkedList((List)collection, type);
        }
        return Collections.checkedCollection(collection, type);
    }

    public static <T> Collection<T> getSynchronizedCollection(Collection<T> collection) {
        Objects.requireNonNull(collection, "Collection must not be null");
        if (collection instanceof NavigableSet) {
            return Collections.synchronizedNavigableSet((NavigableSet)collection);
        }
        if (collection instanceof SortedSet) {
            return Collections.synchronizedSortedSet((SortedSet)collection);
        }
        if (collection instanceof Set) {
            return Collections.synchronizedSet((Set)collection);
        }
        if (collection instanceof List) {
            return Collections.synchronizedList((List)collection);
        }
        return Collections.synchronizedCollection(collection);
    }
}

