/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class Traverser {
    private final Set<Object> objVisited = Collections.newSetFromMap(new IdentityHashMap());
    private final Consumer<NodeVisit> nodeVisitor;

    private Traverser(Consumer<NodeVisit> nodeVisitor) {
        this.nodeVisitor = nodeVisitor;
    }

    public static void traverse(Object root, Consumer<NodeVisit> visitor, Set<Class<?>> classesToSkip) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor cannot be null");
        }
        Traverser traverser = new Traverser(visitor);
        traverser.walk(root, classesToSkip);
    }

    private static void traverse(Object root, Set<Class<?>> classesToSkip, Consumer<Object> objectProcessor) {
        if (objectProcessor == null) {
            throw new IllegalArgumentException("objectProcessor cannot be null");
        }
        Traverser.traverse(root, (NodeVisit visit) -> objectProcessor.accept(visit.getNode()), classesToSkip);
    }

    @Deprecated
    public static void traverse(Object root, Visitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor cannot be null");
        }
        Traverser.traverse(root, (NodeVisit visit) -> visitor.process(visit.getNode()), null);
    }

    @Deprecated
    public static void traverse(Object root, Class<?>[] skip, Visitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor cannot be null");
        }
        HashSet classesToSkip = skip == null ? null : new HashSet(Arrays.asList(skip));
        Traverser.traverse(root, (NodeVisit visit) -> visitor.process(visit.getNode()), classesToSkip);
    }

    private void walk(Object root, Set<Class<?>> classesToSkip) {
        if (root == null) {
            return;
        }
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Class<?> clazz;
            Object current = stack.pollFirst();
            if (current == null || this.objVisited.contains(current) || this.shouldSkipClass(clazz = current.getClass(), classesToSkip)) continue;
            this.objVisited.add(current);
            Map<Field, Object> fields = this.collectFields(current);
            this.nodeVisitor.accept(new NodeVisit(current, fields));
            if (clazz.isArray()) {
                this.processArray(stack, current, classesToSkip);
                continue;
            }
            if (current instanceof Collection) {
                this.processCollection(stack, (Collection)current);
                continue;
            }
            if (current instanceof Map) {
                this.processMap(stack, (Map)current);
                continue;
            }
            this.processFields(stack, current, classesToSkip);
        }
    }

    private Map<Field, Object> collectFields(Object obj) {
        HashMap<Field, Object> fields = new HashMap<Field, Object>();
        List<Field> allFields = ReflectionUtils.getAllDeclaredFields(obj.getClass());
        for (Field field : allFields) {
            try {
                fields.put(field, field.get(obj));
            }
            catch (IllegalAccessException e) {
                fields.put(field, "<inaccessible>");
            }
        }
        return fields;
    }

    private boolean shouldSkipClass(Class<?> clazz, Set<Class<?>> classesToSkip) {
        if (classesToSkip == null) {
            return false;
        }
        for (Class<?> skipClass : classesToSkip) {
            if (!skipClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private void processArray(Deque<Object> stack, Object array, Set<Class<?>> classesToSkip) {
        int length = Array.getLength(array);
        Class<?> componentType = array.getClass().getComponentType();
        if (!componentType.isPrimitive()) {
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(array, i);
                if (element == null || this.shouldSkipClass(element.getClass(), classesToSkip)) continue;
                stack.addFirst(element);
            }
        }
    }

    private void processCollection(Deque<Object> stack, Collection<?> collection) {
        for (Object element : collection) {
            if (element == null) continue;
            stack.addFirst(element);
        }
    }

    private void processMap(Deque<Object> stack, Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key != null) {
                stack.addFirst(key);
            }
            if (value == null) continue;
            stack.addFirst(value);
        }
    }

    private void processFields(Deque<Object> stack, Object object, Set<Class<?>> classesToSkip) {
        List<Field> fields = ReflectionUtils.getAllDeclaredFields(object.getClass());
        for (Field field : fields) {
            if (field.getType().isPrimitive()) continue;
            try {
                Object value = field.get(object);
                if (value == null || this.shouldSkipClass(value.getClass(), classesToSkip)) continue;
                stack.addFirst(value);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    @Deprecated
    @FunctionalInterface
    public static interface Visitor {
        public void process(Object var1);
    }

    public static class NodeVisit {
        private final Object node;
        private final Map<Field, Object> fields;

        public NodeVisit(Object node, Map<Field, Object> fields) {
            this.node = node;
            this.fields = Collections.unmodifiableMap(new HashMap<Field, Object>(fields));
        }

        public Object getNode() {
            return this.node;
        }

        public Map<Field, Object> getFields() {
            return this.fields;
        }

        public Class<?> getNodeClass() {
            return this.node.getClass();
        }
    }
}

