/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CompactMap;
import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.BigIntegerConversions;
import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

final class DurationConversions {
    private DurationConversions() {
    }

    static Map toMap(Object from, Converter converter) {
        long sec = ((Duration)from).getSeconds();
        int nanos = ((Duration)from).getNano();
        CompactMap<String, Number> target = CompactMap.builder().insertionOrder().build();
        target.put("seconds", sec);
        target.put("nanos", nanos);
        return target;
    }

    static long toLong(Object from, Converter converter) {
        return ((Duration)from).toMillis();
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        Duration duration = (Duration)from;
        return new AtomicLong(duration.toMillis());
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Duration duration = (Duration)from;
        BigInteger epochSeconds = BigInteger.valueOf(duration.getSeconds());
        BigInteger nanos = BigInteger.valueOf(duration.getNano());
        return epochSeconds.multiply(BigIntegerConversions.BILLION).add(nanos);
    }

    static double toDouble(Object from, Converter converter) {
        Duration duration = (Duration)from;
        return BigDecimalConversions.secondsAndNanosToDouble(duration.getSeconds(), duration.getNano()).doubleValue();
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Duration duration = (Duration)from;
        return BigDecimalConversions.secondsAndNanosToDouble(duration.getSeconds(), duration.getNano());
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        Duration duration = (Duration)from;
        Instant epoch = Instant.EPOCH;
        Instant timeAfterDuration = epoch.plus(duration);
        return Timestamp.from(timeAfterDuration);
    }
}

