/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class SystemUtilities {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");

    private SystemUtilities() {
    }

    public static String getExternalVariable(String var) {
        if (StringUtilities.isEmpty(var)) {
            return null;
        }
        String value = System.getProperty(var);
        if (StringUtilities.isEmpty(value)) {
            value = System.getenv(var);
        }
        return StringUtilities.isEmpty(value) ? null : value;
    }

    public static int getAvailableProcessors() {
        return Math.max(1, Runtime.getRuntime().availableProcessors());
    }

    public static MemoryInfo getMemoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        return new MemoryInfo(runtime.totalMemory(), runtime.freeMemory(), runtime.maxMemory());
    }

    public static double getSystemLoadAverage() {
        return ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
    }

    public static boolean isJavaVersionAtLeast(int major, int minor) {
        String[] version = JAVA_VERSION.split("\\.");
        int majorVersion = Integer.parseInt(version[0]);
        int minorVersion = version.length > 1 ? Integer.parseInt(version[1]) : 0;
        return majorVersion > major || majorVersion == major && minorVersion >= minor;
    }

    public static int currentJdkMajorVersion() {
        String spec = System.getProperty("java.specification.version");
        return spec.startsWith("1.") ? Integer.parseInt(spec.substring(2)) : Integer.parseInt(spec);
    }

    public static long getCurrentProcessId() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return 0L;
        }
        try {
            return Long.parseLong(jvmName.substring(0, index));
        }
        catch (NumberFormatException ignored) {
            return 0L;
        }
    }

    public static File createTempDirectory(String prefix) throws IOException {
        File tempDir = Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        tempDir.deleteOnExit();
        return tempDir;
    }

    public static TimeZone getSystemTimeZone() {
        String tzEnv = System.getenv("TZ");
        if (tzEnv != null) {
            try {
                return TimeZone.getTimeZone(tzEnv);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return TimeZone.getDefault();
    }

    public static boolean hasAvailableMemory(long requiredBytes) {
        MemoryInfo info = SystemUtilities.getMemoryInfo();
        return info.getFreeMemory() >= requiredBytes;
    }

    public static Map<String, String> getEnvironmentVariables(Predicate<String> filter) {
        return System.getenv().entrySet().stream().filter(e -> filter == null || filter.test((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new));
    }

    public static List<NetworkInfo> getNetworkInterfaces() throws SocketException {
        ArrayList<NetworkInfo> interfaces = new ArrayList<NetworkInfo>();
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            if (!ni.isUp()) continue;
            ArrayList<InetAddress> addresses = Collections.list(ni.getInetAddresses());
            interfaces.add(new NetworkInfo(ni.getName(), ni.getDisplayName(), addresses, ni.isLoopback()));
        }
        return interfaces;
    }

    public static void addShutdownHook(Runnable hook) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                hook.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
    }

    public static class MemoryInfo {
        private final long totalMemory;
        private final long freeMemory;
        private final long maxMemory;

        public MemoryInfo(long totalMemory, long freeMemory, long maxMemory) {
            this.totalMemory = totalMemory;
            this.freeMemory = freeMemory;
            this.maxMemory = maxMemory;
        }

        public long getTotalMemory() {
            return this.totalMemory;
        }

        public long getFreeMemory() {
            return this.freeMemory;
        }

        public long getMaxMemory() {
            return this.maxMemory;
        }
    }

    public static class NetworkInfo {
        private final String name;
        private final String displayName;
        private final List<InetAddress> addresses;
        private final boolean loopback;

        public NetworkInfo(String name, String displayName, List<InetAddress> addresses, boolean loopback) {
            this.name = name;
            this.displayName = displayName;
            this.addresses = addresses;
            this.loopback = loopback;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public List<InetAddress> getAddresses() {
            return this.addresses;
        }

        public boolean isLoopback() {
            return this.loopback;
        }
    }

    public static class ProcessResult {
        private final int exitCode;
        private final String output;
        private final String error;

        public ProcessResult(int exitCode, String output, String error) {
            this.exitCode = exitCode;
            this.output = output;
            this.error = error;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getOutput() {
            return this.output;
        }

        public String getError() {
            return this.error;
        }
    }
}

