/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.EnumSet;

final class ArrayConversions {
    private ArrayConversions() {
    }

    static Object arrayToArray(Object sourceArray, Class<?> targetArrayType, Converter converter) {
        int length = Array.getLength(sourceArray);
        Class<?> targetComponentType = targetArrayType.getComponentType();
        Object targetArray = Array.newInstance(targetComponentType, length);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(sourceArray, i);
            Object convertedValue = value != null && value.getClass().isArray() ? ArrayConversions.arrayToArray(value, targetComponentType, converter) : (value == null || targetComponentType.isAssignableFrom(value.getClass()) ? value : converter.convert(value, targetComponentType));
            Array.set(targetArray, i, convertedValue);
        }
        return targetArray;
    }

    static Object collectionToArray(Collection<?> collection, Class<?> arrayType, Converter converter) {
        Class<?> componentType = arrayType.getComponentType();
        Object array = Array.newInstance(componentType, collection.size());
        int index = 0;
        for (Object item : collection) {
            Object convertedValue = item instanceof Collection && componentType.isArray() ? ArrayConversions.collectionToArray((Collection)item, componentType, converter) : (item == null || componentType.isAssignableFrom(item.getClass()) ? item : converter.convert(item, componentType));
            Array.set(array, index++, convertedValue);
        }
        return array;
    }

    static Object enumSetToArray(EnumSet<?> enumSet, Class<?> targetArrayType) {
        Class<?> componentType = targetArrayType.getComponentType();
        Object array = Array.newInstance(componentType, enumSet.size());
        int i = 0;
        if (componentType == String.class) {
            for (Enum value : enumSet) {
                Array.set(array, i++, value.name());
            }
        } else if (componentType == Integer.class || componentType == Integer.TYPE || componentType == Long.class || componentType == Long.TYPE) {
            for (Enum value : enumSet) {
                Array.set(array, i++, value.ordinal());
            }
        } else if (componentType == Short.class || componentType == Short.TYPE) {
            for (Enum value : enumSet) {
                int ordinal = value.ordinal();
                if (ordinal > Short.MAX_VALUE) {
                    throw new IllegalArgumentException("Enum ordinal too large for short: " + ordinal);
                }
                Array.set(array, i++, (short)ordinal);
            }
        } else if (componentType == Byte.class || componentType == Byte.TYPE) {
            for (Enum value : enumSet) {
                int ordinal = value.ordinal();
                if (ordinal > 127) {
                    throw new IllegalArgumentException("Enum ordinal too large for byte: " + ordinal);
                }
                Array.set(array, i++, (byte)ordinal);
            }
        } else if (componentType == Class.class) {
            for (Enum value : enumSet) {
                Array.set(array, i++, value.getDeclaringClass());
            }
        } else {
            for (Enum value : enumSet) {
                Array.set(array, i++, value);
            }
        }
        return array;
    }
}

