/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.StringUtilities;
import java.util.Map;

public class Convention {
    private Convention() {
    }

    public static void throwIfNull(Object value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void throwIfNullOrEmpty(String value, String message) {
        if (StringUtilities.isEmpty(value)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void throwIfClassNotFound(String fullyQualifiedClassName, ClassLoader loader) {
        Convention.throwIfNullOrEmpty(fullyQualifiedClassName, "fully qualified ClassName cannot be null or empty");
        Convention.throwIfNull(loader, "loader cannot be null");
        Class<?> c = ClassUtilities.forName(fullyQualifiedClassName, loader);
        if (c == null) {
            throw new IllegalArgumentException("Unknown class: " + fullyQualifiedClassName + " was not found.");
        }
    }

    public static <K, V> void throwIfKeyExists(Map<K, V> map, K key, String message) {
        Convention.throwIfNull(map, "map cannot be null");
        Convention.throwIfNull(key, "key cannot be null");
        if (map.containsKey(key)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void throwIfFalse(boolean logic, String message) {
        if (!logic) {
            throw new IllegalArgumentException(message);
        }
    }
}

