/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import com.cedarsoftware.util.ConcurrentNavigableMapNullSafe;
import com.cedarsoftware.util.ConcurrentNavigableSetNullSafe;
import com.cedarsoftware.util.ConcurrentSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class CaseInsensitiveSet<E>
implements Set<E> {
    private final Map<E, Object> map;
    private static final Object PRESENT = new Object();

    public CaseInsensitiveSet() {
        this.map = new CaseInsensitiveMap<E, Object>();
    }

    public CaseInsensitiveSet(Collection<? extends E> collection) {
        this.map = this.determineBackingMap(collection);
        this.addAll(collection);
    }

    public CaseInsensitiveSet(Collection<? extends E> source, Map backingMap) {
        this.map = backingMap;
        this.addAll(source);
    }

    public CaseInsensitiveSet(int initialCapacity) {
        this.map = new CaseInsensitiveMap<E, Object>(initialCapacity);
    }

    public CaseInsensitiveSet(int initialCapacity, float loadFactor) {
        this.map = new CaseInsensitiveMap<E, Object>(initialCapacity, loadFactor);
    }

    @Override
    public int hashCode() {
        return this.map.keySet().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        return that.size() == this.size() && this.containsAll(that);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.map.putIfAbsent(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.map.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E elem : c) {
            if (!this.add(elem)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        CaseInsensitiveMap other = new CaseInsensitiveMap();
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext()) {
            Object o;
            Object element = o = iterator.next();
            other.put(element, PRESENT);
        }
        Iterator<E> iterator2 = this.map.keySet().iterator();
        boolean modified = false;
        while (iterator2.hasNext()) {
            E elem = iterator2.next();
            if (other.containsKey(elem)) continue;
            iterator2.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object elem : c) {
            Object element = elem;
            if (this.map.remove(element) == null) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public long elementCount() {
        if (this.map instanceof CaseInsensitiveMap) {
            return ((CaseInsensitiveMap)this.map).mappingCount();
        }
        return this.size();
    }

    public void forEach(long parallelismThreshold, Consumer<? super E> action) {
        if (this.map instanceof CaseInsensitiveMap) {
            ((CaseInsensitiveMap)this.map).forEachKey(parallelismThreshold, action);
        } else if (parallelismThreshold <= 1L && (long)this.size() >= parallelismThreshold) {
            this.map.keySet().parallelStream().forEach(action);
        } else {
            this.map.keySet().forEach(action);
        }
    }

    public <U> U searchElements(long parallelismThreshold, Function<? super E, ? extends U> searchFunction) {
        if (this.map instanceof CaseInsensitiveMap) {
            return ((CaseInsensitiveMap)this.map).searchKeys(parallelismThreshold, searchFunction);
        }
        if (parallelismThreshold <= 1L && (long)this.size() >= parallelismThreshold) {
            return this.map.keySet().parallelStream().map(searchFunction).filter(result -> result != null).findFirst().orElse(null);
        }
        for (E element : this.map.keySet()) {
            U result2 = searchFunction.apply(element);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public <U> U reduceElements(long parallelismThreshold, Function<? super E, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (this.map instanceof CaseInsensitiveMap) {
            return ((CaseInsensitiveMap)this.map).reduceKeys(parallelismThreshold, transformer, reducer);
        }
        Object result = null;
        for (E element : this.map.keySet()) {
            U transformed = transformer.apply(element);
            result = result == null ? transformed : reducer.apply(result, transformed);
        }
        return (U)result;
    }

    public Map<E, Object> getBackingMap() {
        return this.map;
    }

    private Map<E, Object> determineBackingMap(Collection<? extends E> source) {
        if (source == null) {
            return new CaseInsensitiveMap();
        }
        if (source instanceof ConcurrentNavigableSetNullSafe) {
            return new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentNavigableMapNullSafe());
        }
        if (source instanceof ConcurrentSkipListSet) {
            return new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentSkipListMap());
        }
        if (source instanceof ConcurrentSet) {
            return new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentHashMapNullSafe());
        }
        if (source instanceof SortedSet) {
            return new CaseInsensitiveMap(Collections.emptyMap(), new TreeMap());
        }
        int size = source.isEmpty() ? 16 : source.size();
        return new CaseInsensitiveMap(size);
    }

    @Deprecated
    public Set<E> minus(Iterable<E> removeMe) {
        for (E me : removeMe) {
            this.remove(me);
        }
        return this;
    }

    @Deprecated
    public Set<E> minus(E removeMe) {
        this.remove(removeMe);
        return this;
    }

    @Deprecated
    public Set<E> plus(Iterable<E> right) {
        for (E item : right) {
            this.add(item);
        }
        return this;
    }

    @Deprecated
    public Set<E> plus(Object right) {
        this.add(right);
        return this;
    }

    public String toString() {
        return this.map.keySet().toString();
    }
}

